/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.model;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IOrdinaryClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.SuffixConstants;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.Util;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClassFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JarPackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.PackageFragmentRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.IReader;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.IndexException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.indexer.Indexer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.JavaIndex;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.JavaNames;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdResourceFile;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.NdType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.TypeRef;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.model.BinaryTypeDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.model.IndexBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.java.model.Package;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.util.CharArrayUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class BinaryTypeFactory {
    private static BinaryTypeDescriptor createDescriptor(PackageFragment pkg, ClassFile classFile) {
        String indexPath;
        PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
        IPath location = JavaIndex.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        String entryName = io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util.concatWith(pkg.names, classFile.getElementName(), '/');
        String name = io.spring.javaformat.eclipse.jdt.jdk8.internal.core.util.Util.concatWith(pkg.names, classFile.getName(), '/');
        String overridePath = root.getClassFilePath(entryName);
        if (overridePath != entryName) {
            entryName = overridePath;
            String versionPath = overridePath.substring(0, overridePath.indexOf(entryName));
            name = String.valueOf(versionPath) + name;
        }
        char[] fieldDescriptor = CharArrayUtils.concat(new char[]{'L'}, name.toCharArray(), new char[]{';'});
        IPath workspacePath = root.getPath();
        if (root instanceof JarPackageFragmentRoot) {
            indexPath = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryTypeDescriptor(location.toString().toCharArray(), fieldDescriptor, workspacePath.toString().toCharArray(), indexPath.toCharArray());
    }

    public static BinaryTypeDescriptor createDescriptor(IOrdinaryClassFile classFile) {
        ClassFile concreteClass = (ClassFile)classFile;
        PackageFragment parent = (PackageFragment)classFile.getParent();
        return BinaryTypeFactory.createDescriptor(parent, concreteClass);
    }

    public static IBinaryType create(IOrdinaryClassFile classFile, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(classFile);
        return BinaryTypeFactory.readType(descriptor, monitor);
    }

    public static IBinaryType readType(BinaryTypeDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        if (JavaIndex.isEnabled()) {
            try {
                return BinaryTypeFactory.readFromIndex(JavaIndex.getIndex(), descriptor, monitor);
            }
            catch (NotInIndexException notInIndexException) {}
        }
        return BinaryTypeFactory.rawReadType(descriptor, true);
    }

    public static ClassFileReader rawReadType(BinaryTypeDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryTypeFactory.rawReadTypeTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public static ClassFileReader rawReadTypeTestForExists(BinaryTypeDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.isInJarFile()) {
            if (CharOperation.indexOf("jrt-fs.jar".toCharArray(), descriptor.location, false) == -1) {
                ZipFile zip;
                block23: {
                    zip = null;
                    try {
                        byte[] contents;
                        zip = JavaModelManager.getJavaModelManager().getZipFile((IPath)new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                        char[] entryNameCharArray = CharArrayUtils.concat(JavaNames.fieldDescriptorToBinaryName(descriptor.fieldDescriptor), SuffixConstants.SUFFIX_class);
                        String entryName = new String(entryNameCharArray);
                        ZipEntry ze22 = zip.getEntry(entryName);
                        if (ze22 == null) break block23;
                        try {
                            contents = Util.getZipEntryByteContent(ze22, zip);
                        }
                        catch (IOException ioe) {
                            throw new JavaModelException(ioe, 985);
                        }
                        ClassFileReader classFileReader = new ClassFileReader(contents, descriptor.indexPath, fullyInitialize);
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        return classFileReader;
                    }
                    catch (CoreException e) {
                        try {
                            throw new JavaModelException(e);
                        }
                        catch (Throwable throwable) {
                            JavaModelManager.getJavaModelManager().closeZipFile(zip);
                            throw throwable;
                        }
                    }
                }
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
            }
        } else {
            byte[] contents;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(new String(descriptor.workspacePath)));
            try {
                Throwable entryName = null;
                Object ze22 = null;
                try (InputStream stream = file.getContents(true);){
                    contents = Util.getInputStreamAsByteArray(stream, -1);
                }
                catch (Throwable ze22) {
                    if (entryName == null) {
                        entryName = ze22;
                    } else if (entryName != ze22) {
                        entryName.addSuppressed(ze22);
                    }
                    throw entryName;
                }
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.getCode() == 368) {
                    throw new FileNotFoundException();
                }
                throw new JavaModelException(e);
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            return new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), fullyInitialize);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBinaryType readFromIndex(JavaIndex index, BinaryTypeDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, NotInIndexException {
        char[] fieldDescriptor = descriptor.fieldDescriptor;
        Nd nd = index.getNd();
        if (descriptor.location == null) throw new NotInIndexException();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (IReader lock = nd.acquireReadLock();){
                TypeRef typeRef = TypeRef.create(nd, descriptor.location, fieldDescriptor);
                NdType type = typeRef.get();
                if (type == null) {
                    NdResourceFile resourceFile = index.getResourceFile(descriptor.location);
                    if (!index.isUpToDate(resourceFile)) throw new NotInIndexException();
                    return null;
                }
                NdResourceFile resourceFile = type.getResourceFile();
                if (index.isUpToDate(resourceFile)) {
                    IndexBinaryType result = new IndexBinaryType(typeRef, descriptor.indexPath);
                    result.initSimpleAttributes();
                    return result;
                }
                throw new NotInIndexException();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IndexException e) {
            Package.log("Index corruption detected. Rebuilding index.", e);
            Indexer.getInstance().requestRebuildIndex();
        }
        throw new NotInIndexException();
    }

    public static final class NotInIndexException
    extends Exception {
    }
}

