/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.Database;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.ModificationLog;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.BaseField;

public class FieldFloat
extends BaseField {
    private final ModificationLog.Tag tag;

    public FieldFloat(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.tag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public float get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getFloat(address + (long)this.offset);
    }

    public void put(Nd nd, long address, float newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.tag);
        try {
            nd.getDB().putFloat(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.tag);
        }
    }

    @Override
    public int getRecordSize() {
        return 4;
    }
}

