/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.Nd;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.Database;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.db.ModificationLog;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.nd.field.BaseField;

public class FieldChar
extends BaseField {
    private final ModificationLog.Tag tag;

    public FieldChar(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.tag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public char get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getChar(address + (long)this.offset);
    }

    public void put(Nd nd, long address, char newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.tag);
        try {
            nd.getDB().putChar(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.tag);
        }
    }

    @Override
    public int getRecordSize() {
        return 2;
    }
}

