/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.core;

import io.spring.javaformat.eclipse.jdt.jdk8.core.IClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.core.IJavaModelStatus;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.ClasspathEntry;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaModelManager;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.JavaProject;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.builder.JavaBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ClasspathValidation {
    private JavaProject project;

    public ClasspathValidation(JavaProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        IJavaModelStatus status;
        IPath outputLocation;
        IClasspathEntry[] rawClasspath;
        JavaModelManager.PerProjectInfo perProjectInfo;
        try {
            perProjectInfo = this.project.getPerProjectInfo();
        }
        catch (JavaModelException javaModelException) {
            IProject resource = this.project.getProject();
            if (resource.isAccessible()) {
                this.project.flushClasspathProblemMarkers(true, true, true);
                JavaBuilder.removeProblemsAndTasksFor((IResource)resource);
            }
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
        synchronized (perProjectInfo2) {
            rawClasspath = perProjectInfo.rawClasspath;
            outputLocation = perProjectInfo.outputLocation;
            status = perProjectInfo.rawClasspathStatus;
        }
        this.project.flushClasspathProblemMarkers(false, true, false);
        if (!status.isOK()) {
            this.project.createClasspathProblemMarker(status);
        }
        this.project.flushClasspathProblemMarkers(false, false, true);
        this.project.flushClasspathProblemMarkers(false, false, false);
        if (rawClasspath != JavaProject.INVALID_CLASSPATH && outputLocation != null) {
            int i = 0;
            while (i < rawClasspath.length) {
                status = ClasspathEntry.validateClasspathEntry(this.project, rawClasspath[i], false, false);
                if (!status.isOK()) {
                    this.project.createClasspathProblemMarker(status);
                }
                ++i;
            }
            status = ClasspathEntry.validateClasspath(this.project, rawClasspath, outputLocation);
            if (status.getCode() != 0) {
                this.project.createClasspathProblemMarker(status);
            }
        }
    }
}

