/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.batch;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.CharOperation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.batch.ClasspathJar;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFileReader;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ClassFormatException;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.classfmt.ExternalAnnotationDecorator;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.AccessRuleSet;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IBinaryType;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.IModule;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.env.NameEnvironmentAnswer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BinaryTypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;

public class ClasspathJmod
extends ClasspathJar {
    public static char[] CLASSES = "classes".toCharArray();
    public static char[] CLASSES_FOLDER = "classes/".toCharArray();

    public ClasspathJmod(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet, String destinationPath) {
        super(file, closeZipFileAtEnd, accessRuleSet, destinationPath);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        block11: {
            if (!this.isPackage(qualifiedPackageName, moduleName)) {
                return null;
            }
            try {
                char[] modName;
                IBinaryType reader;
                block12: {
                    qualifiedBinaryFileName = new String(CharOperation.append(CLASSES_FOLDER, qualifiedBinaryFileName.toCharArray()));
                    reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
                    if (reader == null) break block11;
                    char[] cArray = modName = this.module == null ? null : this.module.name();
                    if (reader instanceof ClassFileReader) {
                        ClassFileReader classReader = reader;
                        if (classReader.moduleName == null) {
                            classReader.moduleName = modName;
                        } else {
                            modName = classReader.moduleName;
                        }
                    }
                    if (this.annotationPaths != null) {
                        String qualifiedClassName = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - "CLASS".length() - 1);
                        for (String annotationPath : this.annotationPaths) {
                            try {
                                if (this.annotationZipFile == null) {
                                    this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(annotationPath, null);
                                }
                                if ((reader = ExternalAnnotationDecorator.create(reader, annotationPath, qualifiedClassName, this.annotationZipFile)).getExternalAnnotationStatus() != BinaryTypeBinding.ExternalAnnotationStatus.TYPE_IS_ANNOTATED) continue;
                                break block12;
                            }
                            catch (IOException iOException) {}
                        }
                        reader = new ExternalAnnotationDecorator(reader, null);
                    }
                }
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName), modName);
            }
            catch (ClassFormatException | IOException exception) {}
        }
        return null;
    }

    @Override
    public boolean hasAnnotationFileFor(String qualifiedTypeName) {
        return this.zipFile.getEntry(String.valueOf(qualifiedTypeName = new String(CharOperation.append(CLASSES_FOLDER, qualifiedTypeName.toCharArray()))) + ".eea") != null;
    }

    @Override
    public synchronized char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        if (this.packageCache != null) {
            return this.singletonModuleNameIf(this.packageCache.contains(qualifiedPackageName));
        }
        this.packageCache = new HashSet(41);
        this.packageCache.add(Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            char[] folder;
            char[] entryName = e.nextElement().getName().toCharArray();
            int index = CharOperation.indexOf('/', entryName);
            if (index == -1 || !CharOperation.equals(CLASSES, folder = CharOperation.subarray(entryName, 0, index))) continue;
            char[] fileName = CharOperation.subarray(entryName, index + 1, entryName.length);
            this.addToPackageCache(new String(fileName), false);
        }
        return this.singletonModuleNameIf(this.packageCache.contains(qualifiedPackageName));
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        qualifiedPackageName = String.valueOf(qualifiedPackageName) + '/';
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String tail;
            String fileName;
            char[] folder;
            char[] entryName = e.nextElement().getName().toCharArray();
            int index = CharOperation.indexOf('/', entryName);
            if (index == -1 || !CharOperation.equals(CLASSES, folder = CharOperation.subarray(entryName, 0, index)) || !(fileName = new String(CharOperation.subarray(entryName, index + 1, entryName.length))).startsWith(qualifiedPackageName) || fileName.length() <= qualifiedPackageName.length() || (tail = fileName.substring(qualifiedPackageName.length())).indexOf(47) != -1 || !tail.toLowerCase().endsWith(".class")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Classpath for JMod file " + this.file.getPath();
    }

    @Override
    public IModule getModule() {
        return this.module;
    }
}

