/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.IJavadocTypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.ModuleReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.TypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BlockScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ClassScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ModuleBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.Scope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding;

public class JavadocModuleReference
extends Expression
implements IJavadocTypeReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public TypeReference typeReference;
    public ModuleReference moduleReference;

    public JavadocModuleReference(char[][] sources, long[] pos, int tagStart, int tagEnd) {
        this.moduleReference = new ModuleReference(sources, pos);
        this.tagSourceStart = tagStart;
        this.tagSourceEnd = tagEnd;
        this.sourceStart = this.moduleReference.sourceStart;
        this.sourceEnd = this.moduleReference.sourceEnd;
        this.bits |= 0x8000;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public int getTagSourceStart() {
        return this.tagSourceStart;
    }

    @Override
    public int getTagSourceEnd() {
        return this.tagSourceEnd;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference typeReference) {
        this.typeReference = typeReference;
        if (this.typeReference != null) {
            this.sourceEnd = this.typeReference.sourceEnd;
        }
    }

    public ModuleReference getModuleReference() {
        return this.moduleReference;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.moduleReference != null) {
            output.append(this.moduleReference.moduleName);
        }
        output.append('/');
        if (this.typeReference != null) {
            this.typeReference.printExpression(indent, output);
        }
        return output;
    }

    public ModuleBinding resolve(Scope scope) {
        return this.moduleReference.resolve(scope);
    }

    private ModuleBinding resolveModule(BlockScope scope) {
        return this.moduleReference.resolve(scope);
    }

    private ModuleBinding resolveModule(ClassScope scope) {
        return this.moduleReference.resolve(scope);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.resolveModule(blockScope);
        if (this.moduleReference.binding != null && this.typeReference != null) {
            return this.typeReference.resolveType(blockScope);
        }
        return null;
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        this.resolveModule(classScope);
        assert (this.moduleReference.binding != null);
        if (this.typeReference != null) {
            return this.typeReference.resolveType(classScope, -1);
        }
        return null;
    }
}

