/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast;

import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.TypeReference;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.codegen.CodeStream;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.flow.FlowContext;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.flow.FlowInfo;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.impl.Constant;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.AnnotationBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ArrayBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BlockScope;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.FieldBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.LookupEnvironment;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ReferenceBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.SourceTypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeVariableBinding;

public class ClassLiteralAccess
extends Expression {
    public TypeReference type;
    public TypeBinding targetType;
    FieldBinding syntheticField;

    public ClassLiteralAccess(int sourceEnd, TypeReference type) {
        this.type = type;
        type.bits |= 0x40000000;
        this.sourceStart = type.sourceStart;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        SourceTypeBinding sourceType = currentScope.outerMostClassScope().enclosingSourceType();
        if (!sourceType.isInterface() && !this.targetType.isBaseType() && currentScope.compilerOptions().targetJDK < 0x310000L) {
            this.syntheticField = sourceType.addSyntheticFieldForClassLiteral(this.targetType, currentScope);
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (valueRequired) {
            codeStream.generateClassLiteralAccessForType(currentScope, this.type.resolvedType, this.syntheticField);
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.type.print(0, output).append(".class");
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.targetType = this.type.resolveType(scope, true);
        if (this.targetType == null) {
            return null;
        }
        LookupEnvironment environment = scope.environment();
        this.targetType = environment.convertToRawType(this.targetType, true);
        if (this.targetType.isArrayType()) {
            ArrayBinding arrayBinding = (ArrayBinding)this.targetType;
            TypeBinding leafComponentType = arrayBinding.leafComponentType;
            if (leafComponentType == TypeBinding.VOID) {
                scope.problemReporter().cannotAllocateVoidArray(this);
                return null;
            }
            if (leafComponentType.isTypeVariable()) {
                scope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)leafComponentType, this);
            }
        } else if (this.targetType.isTypeVariable()) {
            scope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)this.targetType, this);
        }
        ReferenceBinding classType = scope.getJavaLangClass();
        if (scope.compilerOptions().sourceLevel >= 0x310000L) {
            TypeBinding boxedType = null;
            boxedType = this.targetType.id == 6 ? environment.getResolvedJavaBaseType(JAVA_LANG_VOID, scope) : scope.boxing(this.targetType);
            if (environment.usesNullTypeAnnotations()) {
                boxedType = environment.createAnnotatedType(boxedType, new AnnotationBinding[]{environment.getNonNullAnnotation()});
            }
            this.resolvedType = environment.createParameterizedType(classType, new TypeBinding[]{boxedType}, null);
        } else {
            this.resolvedType = classType;
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.type.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

