/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.BindingResolver;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.IBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.IMethodBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ITypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.IVariableBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.ast.StringLiteral;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ArrayBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.BaseTypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.CaptureBinding18;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.IntersectionTypeBinding18;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ParameterizedTypeBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.ReferenceBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeConstants;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeVariableBinding;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.WildcardBinding;

class TypeBinding
implements ITypeBinding {
    private static final StringLiteral EXPRESSION = new StringLiteral(0, 0);
    protected static final IMethodBinding[] NO_METHOD_BINDINGS = new IMethodBinding[0];
    protected static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    protected static final IVariableBinding[] NO_VARIABLE_BINDINGS = new IVariableBinding[0];
    io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding binding;
    private TypeBinding prototype = null;
    private String key;
    protected BindingResolver resolver;
    private ITypeBinding[] typeArguments;

    public static TypeBinding createTypeBinding(BindingResolver resolver, io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding referenceBinding, IBinding declaringMember) {
        return declaringMember != null ? new LocalTypeBinding(resolver, referenceBinding, declaringMember) : new TypeBinding(resolver, referenceBinding);
    }

    public TypeBinding(BindingResolver resolver, io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding binding) {
        this.binding = binding;
        this.resolver = resolver;
        io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding compilerPrototype = binding.prototype();
        this.prototype = (TypeBinding)(compilerPrototype == null || compilerPrototype == binding ? null : resolver.getTypeBinding(compilerPrototype));
    }

    public ITypeBinding getBound() {
        switch (this.binding.kind()) {
            case 516: 
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                if (wildcardBinding.bound == null) break;
                return this.resolver.getTypeBinding(wildcardBinding.bound);
            }
        }
        return null;
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return arrayBinding.dimensions;
    }

    public ITypeBinding getElementType() {
        if (!this.isArray()) {
            return null;
        }
        ArrayBinding arrayBinding = (ArrayBinding)this.binding;
        return this.resolver.getTypeBinding(arrayBinding.leafComponentType);
    }

    public ITypeBinding getTypeDeclaration() {
        if (this.binding instanceof ParameterizedTypeBinding) {
            return this.resolver.getTypeBinding(((ParameterizedTypeBinding)this.binding).genericType());
        }
        return this.resolver.getTypeBinding(this.binding.unannotated());
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    @Override
    public String getName() {
        switch (this.binding.kind()) {
            case 516: 
            case 8196: {
                WildcardBinding wildcardBinding = (WildcardBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(TypeConstants.WILDCARD_NAME);
                if (wildcardBinding.bound != null) {
                    switch (wildcardBinding.boundKind) {
                        case 2: {
                            buffer.append(TypeConstants.WILDCARD_SUPER);
                            break;
                        }
                        case 1: {
                            buffer.append(TypeConstants.WILDCARD_EXTENDS);
                        }
                    }
                    buffer.append(this.getBound().getName());
                }
                return String.valueOf(buffer);
            }
            case 4100: {
                if (this.isCapture()) {
                    return "";
                }
                TypeVariableBinding typeVariableBinding = (TypeVariableBinding)this.binding;
                return new String(typeVariableBinding.sourceName);
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
                StringBuffer buffer = new StringBuffer();
                buffer.append(parameterizedTypeBinding.sourceName());
                ITypeBinding[] tArguments = this.getTypeArguments();
                int typeArgumentsLength = tArguments.length;
                if (typeArgumentsLength != 0) {
                    buffer.append('<');
                    int i = 0;
                    while (i < typeArgumentsLength) {
                        if (i > 0) {
                            buffer.append(',');
                        }
                        buffer.append(tArguments[i].getName());
                        ++i;
                    }
                    buffer.append('>');
                }
                return String.valueOf(buffer);
            }
            case 1028: {
                return this.getTypeDeclaration().getName();
            }
            case 68: {
                ITypeBinding elementType = this.getElementType();
                if (elementType.isLocal() || elementType.isAnonymous() || elementType.isCapture()) {
                    return "";
                }
                int dimensions = this.getDimensions();
                char[] brackets = new char[dimensions * 2];
                int i = dimensions * 2 - 1;
                while (i >= 0) {
                    brackets[i] = 93;
                    brackets[i - 1] = 91;
                    i -= 2;
                }
                StringBuffer buffer = new StringBuffer(elementType.getName());
                buffer.append(brackets);
                return String.valueOf(buffer);
            }
            case 32772: {
                return new String(((IntersectionTypeBinding18)this.binding).getIntersectingTypes()[0].sourceName());
            }
        }
        if (this.isPrimitive() || this.isNullType()) {
            BaseTypeBinding baseTypeBinding = (BaseTypeBinding)this.binding;
            return new String(baseTypeBinding.simpleName);
        }
        if (this.isAnonymous()) {
            return "";
        }
        return new String(this.binding.sourceName());
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.prototype != null) {
            return this.prototype.getTypeArguments();
        }
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding.isParameterizedTypeWithActualArguments()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.binding;
            io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding[] arguments = parameterizedTypeBinding.arguments;
            int argumentsLength = arguments.length;
            ITypeBinding[] newTypeArguments = new ITypeBinding[argumentsLength];
            int i = 0;
            while (i < argumentsLength) {
                ITypeBinding typeBinding = this.resolver.getTypeBinding(arguments[i]);
                if (typeBinding == null) {
                    this.typeArguments = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
                newTypeArguments[i] = typeBinding;
                ++i;
            }
            this.typeArguments = newTypeArguments;
            return newTypeArguments;
        }
        this.typeArguments = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    @Override
    public boolean isAnonymous() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isAnonymousType();
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return this.binding.isArrayType();
    }

    @Override
    public boolean isCapture() {
        return this.binding.isCapture() && !(this.binding instanceof CaptureBinding18);
    }

    public boolean isClass() {
        switch (this.binding.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                return false;
            }
        }
        return this.binding.isClass();
    }

    public boolean isEnum() {
        return this.binding.isEnum();
    }

    public boolean isInterface() {
        switch (this.binding.kind()) {
            case 516: 
            case 4100: 
            case 8196: {
                return false;
            }
        }
        return this.binding.isInterface();
    }

    @Override
    public boolean isLocal() {
        if (this.isClass() || this.isInterface() || this.isEnum()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)this.binding;
            return referenceBinding.isLocalType() && !referenceBinding.isMemberType();
        }
        return false;
    }

    public boolean isNullType() {
        return this.binding == io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding.NULL;
    }

    public boolean isPrimitive() {
        return !this.isNullType() && this.binding.isBaseType();
    }

    public String toString() {
        return this.binding.toString();
    }

    static class LocalTypeBinding
    extends TypeBinding {
        private IBinding declaringMember;

        public LocalTypeBinding(BindingResolver resolver, io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.lookup.TypeBinding binding, IBinding declaringMember) {
            super(resolver, binding);
            this.declaringMember = declaringMember;
        }
    }
}

