/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.InvalidInputException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Expression;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.Scanner;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.util.Util;
import java.util.ArrayList;
import java.util.List;

public class StringLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(StringLiteral.class, "escapedValue", String.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "\"\"";

    static {
        ArrayList propertyList = new ArrayList(2);
        StringLiteral.createPropertyList(StringLiteral.class, propertyList);
        StringLiteral.addProperty(ESCAPED_VALUE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = StringLiteral.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    StringLiteral(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return StringLiteral.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 45;
    }

    @Override
    ASTNode clone0(AST target) {
        StringLiteral result = new StringLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.ast.scanner;
        char[] source = token.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 60: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String token) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public void setLiteralValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        int len = value.length();
        StringBuffer b = new StringBuffer(len + 2);
        b.append("\"");
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            Util.appendEscapedChar(b, c, true);
            ++i;
        }
        b.append("\"");
        this.setEscapedValue(b.toString());
    }

    @Override
    int memSize() {
        int size = 44 + StringLiteral.stringSize(this.escapedValue);
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }
}

