/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom;

import io.spring.javaformat.eclipse.jdt.jdk8.core.compiler.InvalidInputException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTMatcher;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTVisitor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.Name;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.Scanner;
import java.util.ArrayList;
import java.util.List;

public class SimpleName
extends Name {
    public static final SimplePropertyDescriptor IDENTIFIER_PROPERTY = new SimplePropertyDescriptor(SimpleName.class, "identifier", String.class, true);
    public static final SimplePropertyDescriptor VAR_PROPERTY = new SimplePropertyDescriptor(SimpleName.class, "var", Boolean.TYPE, true);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_10_0;
    private String identifier = "MISSING";
    private boolean isVarType = false;

    static {
        ArrayList propertyList = new ArrayList(2);
        SimpleName.createPropertyList(SimpleName.class, propertyList);
        SimpleName.addProperty(IDENTIFIER_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = SimpleName.reapPropertyList(propertyList);
        propertyList = new ArrayList(3);
        SimpleName.createPropertyList(SimpleName.class, propertyList);
        SimpleName.addProperty(IDENTIFIER_PROPERTY, propertyList);
        SimpleName.addProperty(VAR_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_10_0 = SimpleName.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel < 10) {
            return PROPERTY_DESCRIPTORS;
        }
        return PROPERTY_DESCRIPTORS_10_0;
    }

    SimpleName(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return SimpleName.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == IDENTIFIER_PROPERTY) {
            if (get) {
                return this.getIdentifier();
            }
            this.setIdentifier((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == VAR_PROPERTY) {
            if (get) {
                return this.isVar();
            }
            if (Long.compare(this.ast.scanner.complianceLevel, 0x360000L) < 0) {
                this.setVar(false);
            } else {
                this.setVar(value);
            }
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 42;
    }

    @Override
    ASTNode clone0(AST target) {
        SimpleName result = new SimpleName(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setIdentifier(this.getIdentifier());
        if (this.ast.apiLevel >= 10 && Long.compare(this.ast.scanner.complianceLevel, 10L) >= 0) {
            result.setVar(this.isVar());
        }
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        long sourceLevel = scanner.sourceLevel;
        long complianceLevel = scanner.complianceLevel;
        try {
            scanner.sourceLevel = 0x2F0000L;
            scanner.complianceLevel = 0x310000L;
            char[] source = identifier.toCharArray();
            scanner.setSource(source);
            int length = source.length;
            scanner.resetTo(0, length - 1);
            try {
                int tokenType = scanner.scanIdentifier();
                if (tokenType != 21) {
                    throw new IllegalArgumentException("Invalid identifier : >" + identifier + "<");
                }
                if (scanner.currentPosition != length) {
                    throw new IllegalArgumentException("Invalid identifier : >" + identifier + "<");
                }
            }
            catch (InvalidInputException e) {
                throw new IllegalArgumentException("Invalid identifier : >" + identifier + "<", e);
            }
        }
        finally {
            this.ast.scanner.sourceLevel = sourceLevel;
            this.ast.scanner.complianceLevel = complianceLevel;
        }
        this.preValueChange(IDENTIFIER_PROPERTY);
        this.identifier = identifier;
        this.postValueChange(IDENTIFIER_PROPERTY);
    }

    public boolean isVar() {
        this.unsupportedBelow10();
        return this.isVarType;
    }

    void setVar(boolean isVar) {
        this.unsupportedBelow10();
        this.preValueChange(VAR_PROPERTY);
        this.isVarType = isVar;
        this.postValueChange(VAR_PROPERTY);
    }

    void internalSetIdentifier(String ident) {
        this.preValueChange(IDENTIFIER_PROPERTY);
        this.identifier = ident;
        this.postValueChange(IDENTIFIER_PROPERTY);
    }

    @Override
    void appendName(StringBuffer buffer) {
        buffer.append(this.getIdentifier());
    }

    @Override
    int memSize() {
        int size = 56;
        if (this.identifier != "MISSING") {
            size += SimpleName.stringSize(this.identifier);
        }
        return size;
    }

    @Override
    int treeSize() {
        return this.memSize();
    }
}

