/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRegistryImpl;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Timed
@Interceptor
@Priority(value=1010)
public class TimedInterceptor {
    private final MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.APPLICATION);

    @Inject
    TimedInterceptor() {
    }

    @AroundConstruct
    Object timedConstructor(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object timedMethod(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object timedTimeout(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object timedCallable(InvocationContext invocationContext, E element) throws Exception {
        Set<MetricID> ids = ((MetricsRegistryImpl)this.registry).getMemberToMetricMappings().getTimers(new CDIMemberInfoAdapter<E>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        List contexts = ids.stream().map(metricID -> {
            Timer metric = (Timer)this.registry.getTimers().get(metricID);
            if (metric == null) {
                throw SmallRyeMetricsMessages.msg.noMetricFoundInRegistry(MetricType.TIMER, (MetricID)metricID);
            }
            return metric;
        }).map(Timer::time).collect(Collectors.toList());
        try {
            Object object = invocationContext.proceed();
            return object;
        }
        finally {
            for (Timer.Context timeContext : contexts) {
                timeContext.stop();
            }
        }
    }
}

