/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.metrics.DefaultMetadata;
import org.eclipse.microprofile.metrics.MetricType;

public class ExtendedMetadata
extends DefaultMetadata {
    private final String mbean;
    private final boolean multi;
    private final Optional<Boolean> prependsScopeToOpenMetricsName;
    private final boolean skipsScopeInOpenMetricsExportCompletely;
    private final Optional<String> openMetricsKeyOverride;

    public ExtendedMetadata(String name, MetricType type) {
        this(name, null, null, type, null, null, false);
    }

    public ExtendedMetadata(String name, MetricType type, String unit, String description, boolean skipsScopeInOpenMetricsExportCompletely) {
        this(name, null, description, type, unit, null, false, Optional.of(true), skipsScopeInOpenMetricsExportCompletely, null);
    }

    public ExtendedMetadata(String name, MetricType type, String unit, String description, boolean skipsScopeInOpenMetricsExportCompletely, String openMetricsKey) {
        this(name, null, description, type, unit, null, false, Optional.of(true), skipsScopeInOpenMetricsExportCompletely, openMetricsKey);
    }

    public ExtendedMetadata(String name, String displayName, String description, MetricType typeRaw, String unit) {
        this(name, displayName, description, typeRaw, unit, null, false, Optional.empty());
    }

    public ExtendedMetadata(String name, String displayName, String description, MetricType typeRaw, String unit, String mbean, boolean multi) {
        this(name, displayName, description, typeRaw, unit, mbean, multi, Optional.empty());
    }

    public ExtendedMetadata(String name, String displayName, String description, MetricType typeRaw, String unit, String mbean, boolean multi, Optional<Boolean> prependsScopeToOpenMetricsName) {
        this(name, displayName, description, typeRaw, unit, mbean, multi, prependsScopeToOpenMetricsName, false, null);
    }

    public ExtendedMetadata(String name, String displayName, String description, MetricType typeRaw, String unit, String mbean, boolean multi, Optional<Boolean> prependsScopeToOpenMetricsName, boolean skipsScopeInOpenMetricsExportCompletely, String openMetricsKeyOverride) {
        super(name, displayName, description, typeRaw, unit, true);
        this.mbean = mbean;
        this.multi = multi;
        this.prependsScopeToOpenMetricsName = prependsScopeToOpenMetricsName;
        this.skipsScopeInOpenMetricsExportCompletely = skipsScopeInOpenMetricsExportCompletely;
        this.openMetricsKeyOverride = Optional.ofNullable(openMetricsKeyOverride);
    }

    public String getMbean() {
        return this.mbean;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public Optional<Boolean> prependsScopeToOpenMetricsName() {
        return this.prependsScopeToOpenMetricsName;
    }

    public boolean isSkipsScopeInOpenMetricsExportCompletely() {
        return this.skipsScopeInOpenMetricsExportCompletely;
    }

    public Optional<String> getOpenMetricsKeyOverride() {
        return this.openMetricsKeyOverride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedMetadata that = (ExtendedMetadata)((Object)o);
        return this.multi == that.multi && Objects.equals(this.prependsScopeToOpenMetricsName, that.prependsScopeToOpenMetricsName) && Objects.equals(this.skipsScopeInOpenMetricsExportCompletely, that.skipsScopeInOpenMetricsExportCompletely) && Objects.equals(this.openMetricsKeyOverride, that.openMetricsKeyOverride) && Objects.equals(this.mbean, that.mbean);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mbean, this.multi, this.prependsScopeToOpenMetricsName, this.skipsScopeInOpenMetricsExportCompletely, this.openMetricsKeyOverride);
    }
}

