/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class EpollProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollProvider.class);
    private static final String EPOLL_ENABLED_KEY = "io.lettuce.core.epoll";
    private static final boolean EPOLL_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get((String)"io.lettuce.core.epoll", (String)"true"));
    private static final boolean EPOLL_AVAILABLE;
    private static final EpollResources epollResources;

    public static boolean isAvailable() {
        return EPOLL_AVAILABLE && EPOLL_ENABLED;
    }

    static void checkForEpollLibrary() {
        LettuceAssert.assertState(EPOLL_ENABLED, String.format("epoll use is disabled via System properties (%s)", EPOLL_ENABLED_KEY));
        LettuceAssert.assertState(EpollProvider.isAvailable(), "netty-transport-native-epoll is not available. Make sure netty-transport-native-epoll library on the class path and supported by your operating system.");
    }

    public static boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
        return epollResources.isEventLoopGroup(type);
    }

    public static EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        return epollResources.newEventLoopGroup(nThreads, threadFactory);
    }

    static Class<? extends Channel> domainSocketChannelClass() {
        return epollResources.domainSocketChannelClass();
    }

    static Class<? extends Channel> socketChannelClass() {
        return epollResources.socketChannelClass();
    }

    static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        return epollResources.eventLoopGroupClass();
    }

    static SocketAddress newSocketAddress(String socketPath) {
        return epollResources.newSocketAddress(socketPath);
    }

    static {
        boolean availability = false;
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            availability = Epoll.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        EPOLL_AVAILABLE = availability;
        if (EPOLL_AVAILABLE) {
            logger.debug("Starting with epoll library");
            epollResources = AvailableEpollResources.INSTANCE;
        } else {
            logger.debug("Starting without optional epoll library");
            epollResources = UnavailableEpollResources.INSTANCE;
        }
    }

    static enum AvailableEpollResources implements EpollResources
    {
        INSTANCE;


        @Override
        public boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(EpollEventLoopGroup.class);
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            EpollProvider.checkForEpollLibrary();
            return new EpollEventLoopGroup(nThreads, threadFactory);
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return EpollDomainSocketChannel.class;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return EpollSocketChannel.class;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            EpollProvider.checkForEpollLibrary();
            return EpollEventLoopGroup.class;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            EpollProvider.checkForEpollLibrary();
            return new DomainSocketAddress(socketPath);
        }
    }

    static enum UnavailableEpollResources implements EpollResources
    {
        INSTANCE;


        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
            EpollProvider.checkForEpollLibrary();
            return false;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            EpollProvider.checkForEpollLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            EpollProvider.checkForEpollLibrary();
            return null;
        }
    }

    public static interface EpollResources {
        public boolean isEventLoopGroup(Class<? extends EventExecutorGroup> var1);

        public EventLoopGroup newEventLoopGroup(int var1, ThreadFactory var2);

        public Class<? extends Channel> domainSocketChannelClass();

        public Class<? extends Channel> socketChannelClass();

        public Class<? extends EventLoopGroup> eventLoopGroupClass();

        public SocketAddress newSocketAddress(String var1);
    }
}

