/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import io.kubernetes.client.openapi.models.V1ServiceAccountFluent;
import io.kubernetes.client.openapi.models.V1ServiceAccountFluentImpl;
import java.util.Objects;

public class V1ServiceAccountBuilder
extends V1ServiceAccountFluentImpl<V1ServiceAccountBuilder>
implements VisitableBuilder<V1ServiceAccount, V1ServiceAccountBuilder> {
    V1ServiceAccountFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceAccountBuilder() {
        this(true);
    }

    public V1ServiceAccountBuilder(Boolean validationEnabled) {
        this(new V1ServiceAccount(), validationEnabled);
    }

    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1ServiceAccount(), validationEnabled);
    }

    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent, V1ServiceAccount instance) {
        this(fluent, instance, true);
    }

    public V1ServiceAccountBuilder(V1ServiceAccountFluent<?> fluent, V1ServiceAccount instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSecrets(instance.getSecrets());
        this.validationEnabled = validationEnabled;
    }

    public V1ServiceAccountBuilder(V1ServiceAccount instance) {
        this(instance, (Boolean)true);
    }

    public V1ServiceAccountBuilder(V1ServiceAccount instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSecrets(instance.getSecrets());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1ServiceAccount build() {
        V1ServiceAccount buildable = new V1ServiceAccount();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setAutomountServiceAccountToken(this.fluent.isAutomountServiceAccountToken());
        buildable.setImagePullSecrets(this.fluent.getImagePullSecrets());
        buildable.setKind(this.fluent.getKind());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setSecrets(this.fluent.getSecrets());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServiceAccountBuilder that = (V1ServiceAccountBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

