/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.kubernetes.client.openapi.models.V1APIGroupBuilder;
import io.kubernetes.client.openapi.models.V1APIGroupFluentImpl;
import io.kubernetes.client.openapi.models.V1APIGroupList;
import io.kubernetes.client.openapi.models.V1APIGroupListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1APIGroupListFluentImpl<A extends V1APIGroupListFluent<A>>
extends BaseFluent<A>
implements V1APIGroupListFluent<A> {
    private String apiVersion;
    private List<V1APIGroupBuilder> groups;
    private String kind;

    public V1APIGroupListFluentImpl() {
    }

    public V1APIGroupListFluentImpl(V1APIGroupList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToGroups(int index, V1APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList<V1APIGroupBuilder>();
        }
        V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
        this._visitables.get("groups").add(index >= 0 ? index : this._visitables.get("groups").size(), builder);
        this.groups.add(index >= 0 ? index : this.groups.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, V1APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList<V1APIGroupBuilder>();
        }
        V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
        if (index < 0 || index >= this._visitables.get("groups").size()) {
            this._visitables.get("groups").add(builder);
        } else {
            this._visitables.get("groups").set(index, builder);
        }
        if (index < 0 || index >= this.groups.size()) {
            this.groups.add(builder);
        } else {
            this.groups.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGroups(V1APIGroup ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<V1APIGroupBuilder>();
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<V1APIGroup> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<V1APIGroupBuilder>();
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(V1APIGroup ... items) {
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            if (this.groups == null) continue;
            this.groups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<V1APIGroup> items) {
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            if (this.groups == null) continue;
            this.groups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGroups(Predicate<V1APIGroupBuilder> predicate) {
        if (this.groups == null) {
            return (A)this;
        }
        Iterator<V1APIGroupBuilder> each = this.groups.iterator();
        Object visitables = this._visitables.get("groups");
        while (each.hasNext()) {
            V1APIGroupBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1APIGroup> getGroups() {
        return V1APIGroupListFluentImpl.build(this.groups);
    }

    @Override
    public List<V1APIGroup> buildGroups() {
        return V1APIGroupListFluentImpl.build(this.groups);
    }

    @Override
    public V1APIGroup buildGroup(int index) {
        return this.groups.get(index).build();
    }

    @Override
    public V1APIGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    @Override
    public V1APIGroup buildLastGroup() {
        return this.groups.get(this.groups.size() - 1).build();
    }

    @Override
    public V1APIGroup buildMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        for (V1APIGroupBuilder item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        for (V1APIGroupBuilder item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<V1APIGroup> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").removeAll(this.groups);
        }
        if (groups != null) {
            this.groups = new ArrayList<V1APIGroupBuilder>();
            for (V1APIGroup item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(V1APIGroup ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (V1APIGroup item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> addNewGroup() {
        return new GroupsNestedImpl();
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> addNewGroupLike(V1APIGroup item) {
        return new GroupsNestedImpl(-1, item);
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> setNewGroupLike(int index, V1APIGroup item) {
        return new GroupsNestedImpl(index, item);
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editGroup(int index) {
        if (this.groups.size() <= index) {
            throw new RuntimeException("Can't edit groups. Index exceeds size.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editFirstGroup() {
        if (this.groups.size() == 0) {
            throw new RuntimeException("Can't edit first groups. The list is empty.");
        }
        return this.setNewGroupLike(0, this.buildGroup(0));
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editLastGroup() {
        int index = this.groups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last groups. The list is empty.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public V1APIGroupListFluent.GroupsNested<A> editMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!predicate.apply(this.groups.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching groups. No match found.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroupListFluentImpl that = (V1APIGroupListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groups, this.kind, super.hashCode());
    }

    public class GroupsNestedImpl<N>
    extends V1APIGroupFluentImpl<V1APIGroupListFluent.GroupsNested<N>>
    implements V1APIGroupListFluent.GroupsNested<N>,
    Nested<N> {
        private final V1APIGroupBuilder builder;
        private final int index;

        GroupsNestedImpl(int index, V1APIGroup item) {
            this.index = index;
            this.builder = new V1APIGroupBuilder(this, item);
        }

        GroupsNestedImpl() {
            this.index = -1;
            this.builder = new V1APIGroupBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIGroupListFluentImpl.this.setToGroups(this.index, this.builder.build());
        }

        @Override
        public N endGroup() {
            return this.and();
        }
    }
}

