/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1HTTPIngressRuleValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.")
public class ExtensionsV1beta1IngressRule {
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private String host;
    public static final String SERIALIZED_NAME_HTTP = "http";
    @SerializedName(value="http")
    private ExtensionsV1beta1HTTPIngressRuleValue http;

    public ExtensionsV1beta1IngressRule host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the \"host\" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to    the IP in the Spec of the parent Ingress. 2. The `:` delimiter is not respected because ports are not allowed.    Currently the port of an Ingress is implicitly :80 for http and    :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.  Host can be \"precise\" which is a domain name without the terminating dot of a network host (e.g. \"foo.bar.com\") or \"wildcard\", which is a domain name prefixed with a single wildcard label (e.g. \"*.foo.com\"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == \"*\"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public ExtensionsV1beta1IngressRule http(ExtensionsV1beta1HTTPIngressRuleValue http) {
        this.http = http;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExtensionsV1beta1HTTPIngressRuleValue getHttp() {
        return this.http;
    }

    public void setHttp(ExtensionsV1beta1HTTPIngressRuleValue http) {
        this.http = http;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsV1beta1IngressRule extensionsV1beta1IngressRule = (ExtensionsV1beta1IngressRule)o;
        return Objects.equals(this.host, extensionsV1beta1IngressRule.host) && Objects.equals(this.http, extensionsV1beta1IngressRule.http);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.http);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtensionsV1beta1IngressRule {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    http: ").append(this.toIndentedString(this.http)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

