/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.wechat.controller;

import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.core.NotAction;
import com.jfinal.kit.HashKit;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.JsTicket;
import io.jboot.Jboot;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import io.jboot.wechat.JbootWechatConfig;
import io.jboot.wechat.WechatApis;
import io.jboot.wechat.interceptor.WechatApiConfigInterceptor;
import io.jboot.wechat.interceptor.WechatUserInterceptor;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

@Before(value={WechatApiConfigInterceptor.class, WechatUserInterceptor.class})
public abstract class JbootWechatController
extends JbootController {
    public static final String SESSION_WECHAT_OPEN_ID = "_jboot_wechat_open_id_";
    public static final String SESSION_WECHAT_ACCESS_TOKEN = "_jboot_wechat_access_token_";
    public static final String SESSION_WECHAT_SCOPE = "_jboot_wechat_scope_";
    public static final String SESSION_WECHAT_USER_JSON = "_jboot_wechat_json_";
    public static final String ATTR_USER_OBJECT = "_jboot_user_object_";

    public ApiConfig getApiConfig() {
        return ApiConfigKit.getApiConfig();
    }

    @Clear(value={WechatUserInterceptor.class})
    public void wechatCallback() {
        String gotoUrl = this.getPara("goto");
        String code = this.getPara("code");
        if (StrUtil.isBlank((String)code)) {
            this.renderText("\u83b7\u53d6\u4e0d\u5230\u6b63\u786e\u7684code\u4fe1\u606f");
            return;
        }
        String wechatOpenId = (String)this.getSessionAttr(SESSION_WECHAT_OPEN_ID);
        String accessToken = (String)this.getSessionAttr(SESSION_WECHAT_ACCESS_TOKEN);
        if (StrUtil.isNotBlank(wechatOpenId) && StrUtil.isNotBlank(accessToken)) {
            this.doRedirect(gotoUrl, wechatOpenId, accessToken);
            return;
        }
        ApiResult result = WechatApis.getAccessTokenAndOpenId(code);
        if (result == null) {
            this.renderText("\u7f51\u7edc\u9519\u8bef\uff0c\u83b7\u53d6\u4e0d\u5230\u5fae\u4fe1\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return;
        }
        if (result.isSucceed()) {
            wechatOpenId = result.getStr("openid");
            accessToken = result.getStr("access_token");
            this.setSessionAttr(SESSION_WECHAT_OPEN_ID, wechatOpenId);
            this.setSessionAttr(SESSION_WECHAT_ACCESS_TOKEN, accessToken);
            this.setSessionAttr(SESSION_WECHAT_SCOPE, result.getStr("scope"));
        } else {
            wechatOpenId = (String)this.getSessionAttr(SESSION_WECHAT_OPEN_ID);
            accessToken = (String)this.getSessionAttr(SESSION_WECHAT_ACCESS_TOKEN);
            if (StrUtil.isBlank((String)wechatOpenId) || StrUtil.isBlank((String)accessToken)) {
                this.renderText("\u9519\u8bef\uff1a" + result.getErrorMsg());
                return;
            }
        }
        if ("snsapi_base".equalsIgnoreCase(result.getStr("scope"))) {
            this.redirect(gotoUrl);
            return;
        }
        this.doRedirect(gotoUrl, wechatOpenId, accessToken);
    }

    private void doRedirect(String gotoUrl, String wechatOpenId, String accessToken) {
        ApiResult apiResult = WechatApis.getUserInfo(accessToken, wechatOpenId);
        if (!apiResult.isSucceed()) {
            this.redirect(gotoUrl);
            return;
        }
        this.setSessionAttr(SESSION_WECHAT_USER_JSON, apiResult.getJson());
        this.redirect(gotoUrl);
    }

    @NotAction
    public void clearWechatSession() {
        this.removeSessionAttr(SESSION_WECHAT_OPEN_ID);
        this.removeSessionAttr(SESSION_WECHAT_ACCESS_TOKEN);
        this.removeSessionAttr(SESSION_WECHAT_USER_JSON);
    }

    @NotAction
    public void initJsSdkConfig() {
        JbootWechatConfig config = Jboot.config(JbootWechatConfig.class);
        String url = this.getRequest().getRequestURL().toString().split("#")[0];
        String query = this.getRequest().getQueryString();
        if (StrUtil.isNotBlank(query)) {
            url = url.concat("?").concat(query);
        }
        JsTicket jsTicket = WechatApis.getTicket(WechatApis.JsApiType.jsapi);
        String _wxJsApiTicket = jsTicket.getTicket();
        String noncestr = StrUtil.uuid();
        String timestamp = System.currentTimeMillis() / 1000L + "";
        TreeMap<String, String> _wxMap = new TreeMap<String, String>();
        _wxMap.put("noncestr", noncestr);
        _wxMap.put("timestamp", timestamp);
        _wxMap.put("jsapi_ticket", _wxJsApiTicket);
        _wxMap.put("url", url);
        StringBuilder paramsBuilder = new StringBuilder();
        for (Map.Entry param : _wxMap.entrySet()) {
            paramsBuilder.append((String)param.getKey()).append("=").append((String)param.getValue()).append("&");
        }
        String signString = paramsBuilder.substring(0, paramsBuilder.length() - 1);
        String signature = HashKit.sha1((String)signString);
        this.setAttr("wechatDebug", config.getDebug());
        this.setAttr("wechatAppId", this.getApiConfig().getAppId());
        this.setAttr("wechatNoncestr", noncestr);
        this.setAttr("wechatTimestamp", timestamp);
        this.setAttr("wechatSignature", signature);
    }

    public boolean isAllowVisit() {
        HttpServletRequest req = this.getRequest();
        if (RequestUtil.isWechatPcBrowser(req)) {
            return false;
        }
        return RequestUtil.isWechatBrowser(req);
    }

    @NotAction
    public void doNotAlloVisitRedirect() {
        this.renderText("jboot wechat error, cannot visit in this browser.");
    }

    public <T> T getCurrentUser() {
        return (T)this.getAttr(ATTR_USER_OBJECT);
    }

    public abstract Object doGetUserByOpenId(String var1);

    public abstract Object doSaveOrUpdateUserByApiResult(ApiResult var1);
}

