/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.wechat;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.JsTicket;
import com.jfinal.weixin.sdk.api.MenuApi;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import io.jboot.utils.HttpUtil;
import java.util.Map;
import java.util.concurrent.Callable;

public class WechatApis {
    private static String apiUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";

    public static ApiResult createMenu(String jsonString) {
        return MenuApi.createMenu((String)jsonString);
    }

    public static ApiResult getUserInfo(String token, String openId) {
        Kv pm = Kv.by((Object)"access_token", (Object)token).set((Object)"openid", (Object)openId).set((Object)"lang", (Object)"zh_CN");
        String jsonResult = HttpUtil.httpGet("https://api.weixin.qq.com/sns/userinfo", (Map<String, Object>)pm);
        if (jsonResult == null) {
            return null;
        }
        return new ApiResult(jsonResult);
    }

    public static ApiResult getAccessTokenAndOpenId(String code) {
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={appid}&secret={secret}&code={code}&grant_type=authorization_code";
        String getOpenIdUrl = url.replace("{appid}", ApiConfigKit.getAppId()).replace("{secret}", ApiConfigKit.getApiConfig().getAppSecret()).replace("{code}", code);
        String jsonResult = HttpUtil.httpGet(getOpenIdUrl);
        if (jsonResult == null) {
            return null;
        }
        return new ApiResult(jsonResult);
    }

    public static JsTicket getTicket(JsApiType jsApiType) {
        String access_token = AccessTokenApi.getAccessTokenStr();
        String appId = ApiConfigKit.getApiConfig().getAppId();
        String key = appId + ':' + jsApiType.name();
        final ParaMap pm = ParaMap.create((String)"access_token", (String)access_token).put("type", jsApiType.name());
        String jsTicketJson = ApiConfigKit.getAccessTokenCache().get(key);
        JsTicket jsTicket = null;
        if (StrKit.notBlank((String)jsTicketJson)) {
            jsTicket = new JsTicket(jsTicketJson);
        }
        if (null == jsTicket || !jsTicket.isAvailable()) {
            jsTicket = (JsTicket)RetryUtils.retryOnException((int)3, (Callable)new Callable<JsTicket>(){

                @Override
                public JsTicket call() throws Exception {
                    return new JsTicket(HttpUtils.get((String)apiUrl, (Map)pm.getData()));
                }
            });
            if (null != jsApiType) {
                ApiConfigKit.getAccessTokenCache().set(key, jsTicket.getCacheJson());
            }
        }
        return jsTicket;
    }

    public static enum JsApiType {
        jsapi,
        wx_card;

    }
}

