/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.session;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class JbootHttpSession
implements HttpSession {
    private final String id;
    private final long createdAt;
    private volatile long lastAccessedAt;
    private int maxInactiveInterval;
    private final ServletContext servletContext;
    private final Map<String, Object> newAttributes = Maps.newHashMap();
    private final Set<String> deleteAttribute = Sets.newHashSet();
    private final Map<String, Object> sessionStore;
    private volatile boolean invalid;
    private volatile boolean dataChanged;
    private volatile boolean empty;

    public JbootHttpSession(String id, ServletContext servletContext, Map<String, Object> sessionStore) {
        this.id = id;
        this.servletContext = servletContext;
        this.sessionStore = sessionStore;
        this.lastAccessedAt = this.createdAt = System.currentTimeMillis();
        this.empty = sessionStore.isEmpty();
    }

    public long getCreationTime() {
        return this.createdAt;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedAt;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String name) {
        this.checkValid();
        if (this.newAttributes.containsKey(name)) {
            return this.newAttributes.get(name);
        }
        if (this.deleteAttribute.contains(name)) {
            return null;
        }
        return this.sessionStore.get(name);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkValid();
        HashSet names = Sets.newHashSet(this.sessionStore.keySet());
        names.addAll(this.newAttributes.keySet());
        names.removeAll(this.deleteAttribute);
        return Collections.enumeration(names);
    }

    public String[] getValueNames() {
        this.checkValid();
        HashSet names = Sets.newHashSet(this.sessionStore.keySet());
        names.addAll(this.newAttributes.keySet());
        names.removeAll(this.deleteAttribute);
        return names.toArray(new String[0]);
    }

    public void setAttribute(String name, Object value) {
        this.checkValid();
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        this.newAttributes.put(name, value);
        this.deleteAttribute.remove(name);
        this.empty = false;
        this.dataChanged = true;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.checkValid();
        if (this.empty && this.newAttributes.isEmpty()) {
            return;
        }
        if (!this.newAttributes.containsKey(name) && !this.sessionStore.containsKey(name)) {
            return;
        }
        this.deleteAttribute.add(name);
        this.newAttributes.remove(name);
        this.dataChanged = true;
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        this.invalid = true;
        this.dataChanged = true;
    }

    public boolean isNew() {
        return Boolean.TRUE;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public Map<String, Object> snapshot() {
        HashMap snap = Maps.newHashMap();
        snap.putAll(this.sessionStore);
        snap.putAll(this.newAttributes);
        for (String name : this.deleteAttribute) {
            snap.remove(name);
        }
        return snap;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    protected void checkValid() throws IllegalStateException {
        if (this.invalid) {
            throw new IllegalStateException("http session has invalidate");
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

