/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.render.RenderException;
import io.jboot.utils.StrUtil;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class RenderHelpler {
    public static void renderHtml(HttpServletResponse response, String html, String contentType) {
        response.setContentType(contentType);
        try {
            PrintWriter responseWriter = response.getWriter();
            responseWriter.write(html);
        }
        catch (Exception e) {
            throw new RenderException((Throwable)e);
        }
    }

    public static String processCDN(String content, String domain) {
        if (StrUtil.isBlank((String)content)) {
            return content;
        }
        Document doc = Jsoup.parse((String)content);
        Elements jsElements = doc.select("script[src]");
        RenderHelpler.replace(jsElements, "src", domain);
        Elements imgElements = doc.select("img[src]");
        RenderHelpler.replace(imgElements, "src", domain);
        Elements linkElements = doc.select("link[href]");
        RenderHelpler.replace(linkElements, "href", domain);
        return doc.toString();
    }

    private static void replace(Elements elements, String attrName, String domain) {
        for (Element element : elements) {
            String url;
            if (element.hasAttr("cdn-exclude") || StrUtil.isBlank((String)(url = element.attr(attrName))) || !url.startsWith("/") || url.startsWith("//")) continue;
            url = domain + url;
            element.attr(attrName, url);
        }
    }
}

