/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderManager;
import com.jfinal.template.Engine;
import io.jboot.Jboot;
import io.jboot.web.render.JbootWebCdnConfig;
import io.jboot.web.render.RenderHelpler;
import java.util.Enumeration;
import java.util.HashMap;

public class JbootRender
extends Render {
    private static Engine engine;
    private static final String contentType;
    private JbootWebCdnConfig config;

    private Engine getEngine() {
        if (engine == null) {
            engine = RenderManager.me().getEngine();
        }
        return engine;
    }

    public JbootRender(String view) {
        this.view = view;
        this.config = Jboot.config(JbootWebCdnConfig.class);
    }

    public String getContentType() {
        return contentType;
    }

    public void render() {
        this.response.setContentType(this.getContentType());
        HashMap<String, Object> data = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            data.put(attrName, this.request.getAttribute(attrName));
        }
        String html = this.getEngine().getTemplate(this.view).renderToString(data);
        html = this.config.isEnable() ? RenderHelpler.processCDN(html, this.config.getDomain()) : html;
        RenderHelpler.renderHtml(this.response, html, contentType);
    }

    public String toString() {
        return this.view;
    }

    static {
        contentType = "text/html; charset=" + JbootRender.getEncoding();
    }
}

