/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.render;

import com.jfinal.kit.JsonKit;
import com.jfinal.render.JsonRender;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class JbootJsonRender
extends JsonRender {
    private static final String contentType = "application/json; charset=" + JbootJsonRender.getEncoding();
    private static final String contentTypeForIE = "text/html; charset=" + JbootJsonRender.getEncoding();
    private static final Set<String> excludedAttrs = new HashSet<String>(){
        private static final long serialVersionUID = 9186138395157680676L;
        {
            this.add("javax.servlet.request.ssl_session");
            this.add("javax.servlet.request.ssl_session_id");
            this.add("javax.servlet.request.ssl_session_mgr");
            this.add("javax.servlet.request.key_size");
            this.add("javax.servlet.request.cipher_suite");
            this.add("_res");
            this.add("REQUEST");
            this.add("CPATH");
        }
    };
    private boolean forIE = false;
    private String jsonText;
    private String[] attrs;

    public JbootJsonRender() {
    }

    public JbootJsonRender(final String key, final Object value) {
        if (key == null) {
            throw new IllegalArgumentException("The parameter key can not be null.");
        }
        this.jsonText = JsonKit.toJson((Object)new HashMap<String, Object>(){
            {
                this.put(key, value);
            }
        });
    }

    public JbootJsonRender(String[] attrs) {
        this.attrs = attrs;
    }

    public JbootJsonRender(String jsonText) {
        this.jsonText = jsonText;
    }

    public JbootJsonRender(Object object) {
        this.jsonText = JsonKit.toJson((Object)object);
    }

    public JsonRender forIE() {
        this.forIE = true;
        return this;
    }

    public void render() {
        if (this.jsonText == null) {
            this.buildJsonText();
        }
        try {
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setDateHeader("Expires", 0L);
            this.response.setContentType(this.forIE ? contentTypeForIE : contentType);
            PrintWriter writer = this.response.getWriter();
            writer.write(this.jsonText);
        }
        catch (IOException e) {
            throw new RenderException((Throwable)e);
        }
    }

    protected void buildJsonText() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.attrs != null) {
            for (String key : this.attrs) {
                map.put(key, this.request.getAttribute(key));
            }
        } else {
            Enumeration attrs = this.request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String key = (String)attrs.nextElement();
                if (excludedAttrs.contains(key)) continue;
                Object value = this.request.getAttribute(key);
                map.put(key, value);
            }
        }
        this.jsonText = JsonKit.toJson(map);
    }

    public String getJsonText() {
        return this.jsonText;
    }
}

