/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.web.directive.base;

import com.jfinal.plugin.activerecord.Page;
import com.jfinal.template.Env;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.web.directive.base.JbootDirectiveBase;
import java.util.ArrayList;

public abstract class PaginateDirectiveBase
extends JbootDirectiveBase {
    private String previousClass = "previous";
    private String nextClass = "next";
    private String activeClass = "active";
    private String disabledClass = "disabled";
    private String anchor = "anchor";
    private boolean onlyShowPreviousAndNext = false;

    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        int endPage;
        int totalPage;
        this.previousClass = this.getPara("previousClass", scope, "previous");
        this.nextClass = this.getPara("nextClass", scope, "next");
        this.activeClass = this.getPara("activeClass", scope, "active");
        this.disabledClass = this.getPara("disabledClass", scope, "disabled");
        this.anchor = this.getPara("anchor", scope, null);
        this.onlyShowPreviousAndNext = this.getPara("onlyShowPreviousAndNext", scope, Boolean.valueOf(false));
        String previousText = this.getPara("previousText", scope, "\u4e0a\u4e00\u9875");
        String nextText = this.getPara("nextText", scope, "\u4e0b\u4e00\u9875");
        Page<?> page = this.getPage(env, scope, writer);
        int currentPage = page == null ? 1 : page.getPageNumber();
        int n = totalPage = page == null ? 1 : page.getTotalPage();
        if (totalPage <= 0 || currentPage > totalPage) {
            return;
        }
        int startPage = currentPage - 4;
        if (startPage < 1) {
            startPage = 1;
        }
        if ((endPage = currentPage + 4) > totalPage) {
            endPage = totalPage;
        }
        if (currentPage <= 8) {
            startPage = 1;
        }
        if (totalPage - currentPage < 8) {
            endPage = totalPage;
        }
        ArrayList<PaginateItem> pages = new ArrayList<PaginateItem>();
        if (currentPage == 1) {
            pages.add(new PaginateItem(this.previousClass + " " + this.disabledClass, "javascript:;", previousText));
        } else {
            pages.add(new PaginateItem(this.previousClass, this.getUrl(currentPage - 1), previousText));
        }
        if (currentPage > 8 && !this.onlyShowPreviousAndNext) {
            pages.add(new PaginateItem("", this.getUrl(1), "1"));
            pages.add(new PaginateItem("", this.getUrl(2), "2"));
            pages.add(new PaginateItem(this.disabledClass, "javascript:;", "..."));
        }
        if (!this.onlyShowPreviousAndNext) {
            for (int i = startPage; i <= endPage; ++i) {
                if (currentPage == i) {
                    pages.add(new PaginateItem(this.activeClass, "javascript:;", i));
                    continue;
                }
                pages.add(new PaginateItem("", this.getUrl(i), i));
            }
        }
        if (totalPage - currentPage >= 8 && !this.onlyShowPreviousAndNext) {
            pages.add(new PaginateItem(this.disabledClass, "javascript:;", "..."));
            pages.add(new PaginateItem("", this.getUrl(totalPage - 1), totalPage - 1));
            pages.add(new PaginateItem("", this.getUrl(totalPage), totalPage));
        }
        if (currentPage == totalPage) {
            pages.add(new PaginateItem(this.nextClass + " " + this.disabledClass, "javascript:;", nextText));
        } else {
            pages.add(new PaginateItem(this.nextClass, this.getUrl(currentPage + 1), nextText));
        }
        scope.setLocal((Object)this.getPageItemsName(), pages);
        this.renderBody(env, scope, writer);
    }

    public String getPrevious() {
        return this.previousClass;
    }

    public String getNext() {
        return this.nextClass;
    }

    public String getDisabled() {
        return this.disabledClass;
    }

    public String getAnchor() {
        return this.anchor;
    }

    protected abstract String getUrl(int var1);

    protected abstract Page<?> getPage(Env var1, Scope var2, Writer var3);

    protected String getPageItemsName() {
        return "pages";
    }

    public boolean hasEnd() {
        return true;
    }

    public static class PaginateItem {
        private String style;
        private String url;
        private String text;

        public PaginateItem(String style, String url, String text) {
            this.style = style;
            this.url = url;
            this.text = text;
        }

        public PaginateItem(String style, String url, int text) {
            this.style = style;
            this.url = url;
            this.text = text + "";
        }

        public String getStyle() {
            return this.style;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

