/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.JFinal;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StrUtil
extends StrKit {
    private static final Log log = Log.getLog(StrUtil.class);
    private static final String[] htmlChars = new String[]{"&", "<", ">", "'", "\""};
    private static final String[] escapeChars = new String[]{"&amp;", "&lt;", "&gt;", "&#39;", "&quot;"};

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, JFinal.me().getConstants().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlDecode is error", (Throwable)e);
            return string;
        }
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, JFinal.me().getConstants().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlEncode is error", (Throwable)e);
            return string;
        }
    }

    public static String urlRedirect(String redirect) {
        try {
            redirect = new String(redirect.getBytes(JFinal.me().getConstants().getEncoding()), "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            log.error("urlRedirect is error", (Throwable)e);
        }
        return redirect;
    }

    public static boolean areNotEmpty(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String string : strings) {
            if (string != null && !"".equals(string)) continue;
            return false;
        }
        return true;
    }

    public static String requireNonBlank(String string) {
        if (StrUtil.isBlank((String)string)) {
            throw new NullPointerException();
        }
        return string;
    }

    public static String requireNonBlank(String string, String message) {
        if (StrUtil.isBlank((String)string)) {
            throw new NullPointerException(message);
        }
        return string;
    }

    public static String obtainDefaultIfBlank(String string, String defaultValue) {
        return StrUtil.isBlank((String)string) ? defaultValue : string;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && !string.equals("");
    }

    public static boolean isNotBlank(Object o) {
        return o == null ? false : StrUtil.notBlank((String)o.toString());
    }

    public static boolean match(String string, String regex) {
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isDecimal(String str) {
        if (str == null) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char chr = str.charAt(i);
            if (chr >= '0' && chr <= '9' || chr == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        return Pattern.matches("\\w+@(\\w+.)+[a-z]{2,3}", email);
    }

    public static boolean isMobileNumber(String phoneNumber) {
        return Pattern.matches("^(1[3,4,5,6,7,8,9])\\d{9}$", phoneNumber);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static Set<String> splitToSet(String src, String regex) {
        if (src == null) {
            return null;
        }
        String[] strings = src.split(regex);
        HashSet<String> set = new HashSet<String>();
        for (String s : strings) {
            if (StrUtil.isBlank((String)s)) continue;
            set.add(s.trim());
        }
        return set;
    }

    public static String escapeHtml(String content) {
        return StrUtil.isBlank((String)content) ? content : StringUtils.replaceEach((String)StrUtil.unEscapeHtml(content), (String[])htmlChars, (String[])escapeChars);
    }

    public static String unEscapeHtml(String content) {
        return StrUtil.isBlank((String)content) ? content : StringUtils.replaceEach((String)content, (String[])escapeChars, (String[])htmlChars);
    }

    public static void main(String[] args) {
        String url = "http://www.baidu.com?username=aaa";
        System.out.println(StrUtil.urlEncode(url));
    }
}

