/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import io.jboot.components.http.JbootHttpManager;
import io.jboot.components.http.JbootHttpRequest;
import io.jboot.components.http.JbootHttpResponse;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class HttpUtil {
    public static String httpGet(String url) {
        return HttpUtil.httpGet(url, null);
    }

    public static String httpGet(String url, Map<String, Object> paras) {
        return HttpUtil.httpGet(url, paras, null);
    }

    public static String httpGet(String url, Map<String, Object> paras, Map<String, String> headers) {
        JbootHttpRequest request = JbootHttpRequest.create(url, paras, "GET");
        request.addHeaders(headers);
        JbootHttpResponse response = HttpUtil.handle(request);
        return response.isError() ? null : response.getContent();
    }

    public static String httpPost(String url) {
        return HttpUtil.httpPost(url, null, null, null);
    }

    public static String httpPost(String url, String postData) {
        return HttpUtil.httpPost(url, null, null, postData);
    }

    public static String httpPost(String url, Map<String, Object> paras) {
        return HttpUtil.httpPost(url, paras, null, null);
    }

    public static String httpPost(String url, Map<String, Object> paras, String postData) {
        return HttpUtil.httpPost(url, paras, null, postData);
    }

    public static String httpPost(String url, Map<String, Object> paras, Map<String, String> headers, String postData) {
        JbootHttpRequest request = JbootHttpRequest.create(url, paras, "POST");
        request.setPostContent(postData);
        request.addHeaders(headers);
        JbootHttpResponse response = HttpUtil.handle(request);
        return response.isError() ? null : response.getContent();
    }

    public static boolean download(String url, File toFile) {
        return HttpUtil.download(url, null, null, toFile);
    }

    public static boolean download(String url, Map<String, Object> paras, File toFile) {
        return HttpUtil.download(url, paras, null, toFile);
    }

    public static boolean download(String url, Map<String, Object> paras, Map<String, String> headers, File toFile) {
        JbootHttpRequest request = JbootHttpRequest.create(url, paras, "GET");
        request.setDownloadFile(toFile);
        request.addHeaders(headers);
        return HttpUtil.handle(request).getError() == null;
    }

    public static String upload(String url, File file) {
        return HttpUtil.upload(url, null, null, file);
    }

    public static String upload(String url, Map<String, Object> paras, File file) {
        return HttpUtil.upload(url, paras, null, file);
    }

    public static String upload(String url, Map<String, Object> paras, Map<String, String> headers, File file) {
        HashMap<String, Object> newParas = new HashMap<String, Object>();
        if (paras != null) {
            newParas.putAll(paras);
        }
        newParas.put("uploadFile", file);
        JbootHttpRequest request = JbootHttpRequest.create(url, newParas, "POST");
        request.addHeaders(headers);
        JbootHttpResponse response = HttpUtil.handle(request);
        return response.isError() ? null : response.getContent();
    }

    public static JbootHttpResponse handle(JbootHttpRequest request) {
        return JbootHttpManager.me().getJbootHttp().handle(request);
    }
}

