/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.JFinal;
import com.jfinal.kit.PathKit;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    public static String getSuffix(String fileName) {
        if (fileName != null && fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf("."));
        }
        return null;
    }

    public static String removePrefix(String src, String prefix) {
        if (src != null && src.startsWith(prefix)) {
            return src.substring(prefix.length());
        }
        return src;
    }

    public static String removeRootPath(String src) {
        return FileUtil.removePrefix(src, PathKit.getWebRootPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readString(File file) {
        String string;
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = fis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            string = new String(baos.toByteArray(), JFinal.me().getConstants().getEncoding());
        }
        catch (Exception exception) {
            FileUtil.close(fis, baos);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(fis, baos);
            throw throwable;
        }
        FileUtil.close(fis, baos);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, false);
            fos.write(string.getBytes(JFinal.me().getConstants().getEncoding()));
        }
        catch (Exception exception) {
            FileUtil.close(null, fos);
        }
        catch (Throwable throwable) {
            FileUtil.close(null, fos);
            throw throwable;
        }
        FileUtil.close(null, fos);
    }

    private static void close(InputStream is, OutputStream os) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void unzip(String zipFilePath) throws IOException {
        String targetPath = zipFilePath.substring(0, zipFilePath.lastIndexOf("."));
        FileUtil.unzip(zipFilePath, targetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipFilePath, String targetPath) throws IOException {
        block10: {
            try (ZipFile zipFile = new ZipFile(zipFilePath);){
                Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
                if (null == entryEnum) break block10;
                while (entryEnum.hasMoreElements()) {
                    OutputStream os = null;
                    InputStream is = null;
                    try {
                        ZipEntry zipEntry = entryEnum.nextElement();
                        if (zipEntry.isDirectory()) continue;
                        File targetFile = new File(targetPath + File.separator + zipEntry.getName());
                        if (!targetFile.getParentFile().exists()) {
                            targetFile.getParentFile().mkdirs();
                        }
                        os = new BufferedOutputStream(new FileOutputStream(targetFile));
                        is = zipFile.getInputStream(zipEntry);
                        byte[] buffer = new byte[4096];
                        int readLen = 0;
                        while ((readLen = is.read(buffer, 0, 4096)) > 0) {
                            os.write(buffer, 0, readLen);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) continue;
                        os.close();
                    }
                }
            }
        }
    }
}

