/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class FileScanner {
    public static final String ACTION_INIT = "init";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_UPDATE = "update";
    private Timer timer;
    private TimerTask task;
    private String rootDir;
    private int interval;
    private boolean running = false;
    private boolean inited = false;
    private final Map<String, TimeSize> preScan = new HashMap<String, TimeSize>();
    private final Map<String, TimeSize> curScan = new HashMap<String, TimeSize>();

    public FileScanner(String rootDir, int interval) {
        if (rootDir == null) {
            throw new IllegalArgumentException("The parameter rootDir can not be null.");
        }
        this.rootDir = rootDir;
        if (interval <= 0) {
            throw new IllegalArgumentException("The parameter interval must more than zero.");
        }
        this.interval = interval;
    }

    public abstract void onChange(String var1, String var2);

    protected void working() {
        if (!this.rootDir.contains(";")) {
            this.scan(new File(this.rootDir));
        } else {
            String[] paths;
            for (String path : paths = this.rootDir.split(";")) {
                this.scan(new File(path));
            }
        }
        this.compare();
        this.preScan.clear();
        this.preScan.putAll(this.curScan);
        this.curScan.clear();
    }

    protected void scan(File file) {
        File[] fs;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            try {
                this.curScan.put(file.getCanonicalPath(), new TimeSize(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (file.isDirectory() && (fs = file.listFiles()) != null && fs.length > 0) {
            for (File f : fs) {
                this.scan(f);
            }
        }
    }

    protected void compare() {
        if (!this.inited) {
            for (Map.Entry<String, TimeSize> entry : this.curScan.entrySet()) {
                this.onChange(ACTION_INIT, entry.getKey());
            }
            this.inited = true;
            return;
        }
        for (Map.Entry<String, TimeSize> entry : this.curScan.entrySet()) {
            if (this.preScan.get(entry.getKey()) != null) continue;
            this.onChange(ACTION_ADD, entry.getKey());
        }
        for (Map.Entry<String, TimeSize> entry : this.preScan.entrySet()) {
            if (this.curScan.get(entry.getKey()) != null) continue;
            this.onChange(ACTION_DELETE, entry.getKey());
        }
        for (Map.Entry<String, TimeSize> entry : this.curScan.entrySet()) {
            TimeSize pre = this.preScan.get(entry.getKey());
            if (pre == null || pre.equals(entry.getValue())) continue;
            this.onChange(ACTION_UPDATE, entry.getKey());
        }
    }

    public void start() {
        if (!this.running) {
            this.timer = new Timer("Jboot-File-Scanner", true);
            this.task = new TimerTask(){

                @Override
                public void run() {
                    FileScanner.this.working();
                }
            };
            this.timer.schedule(this.task, 0L, 1000L * (long)this.interval);
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            this.timer.cancel();
            this.task.cancel();
            this.running = false;
        }
    }

    class TimeSize {
        final long time;
        final long size;

        public TimeSize(File file) {
            this.time = file.lastModified();
            this.size = file.length();
        }

        public int hashCode() {
            return (int)(this.time ^ this.size);
        }

        public boolean equals(Object o) {
            if (o instanceof TimeSize) {
                TimeSize ts = (TimeSize)o;
                return ts.time == this.time && ts.size == this.size;
            }
            return false;
        }

        public String toString() {
            return "TimeSize{time=" + this.time + ", size=" + this.size + '}';
        }
    }
}

