/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.utils;

import com.jfinal.core.Controller;
import com.jfinal.kit.Base64Kit;
import com.jfinal.kit.HashKit;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.utils.StrUtil;
import io.jboot.web.JbootWebConfig;
import java.math.BigInteger;

public class CookieUtil {
    private static final String COOKIE_SEPARATOR = "#";
    private static String COOKIE_ENCRYPT_KEY = Jboot.config(JbootWebConfig.class).getCookieEncryptKey();
    private static Log log = Log.getLog(CookieUtil.class);

    public static void initEncryptKey(String key) {
        COOKIE_ENCRYPT_KEY = key;
    }

    public static void put(Controller ctr, String key, String value) {
        CookieUtil.put(ctr, key, value, 604800);
    }

    public static void put(Controller ctr, String key, Object value) {
        CookieUtil.put(ctr, key, value.toString());
    }

    public static void put(Controller ctr, String key, String value, int maxAgeInSeconds) {
        String cookie = CookieUtil.buildCookieValue(value, maxAgeInSeconds);
        ctr.setCookie(key, cookie, maxAgeInSeconds);
    }

    public static void put(Controller ctr, String key, String value, String domain) {
        CookieUtil.put(ctr, key, value, 604800, domain);
    }

    public static void put(Controller ctr, String key, String value, int maxAgeInSeconds, String domain) {
        String cookie = CookieUtil.buildCookieValue(value, maxAgeInSeconds);
        ctr.setCookie(key, cookie, maxAgeInSeconds, null, domain, false);
    }

    public static void remove(Controller ctr, String key) {
        ctr.removeCookie(key);
    }

    public static void remove(Controller ctr, String key, String path, String domain) {
        ctr.removeCookie(key, path, domain);
    }

    public static String get(Controller ctr, String key) {
        String encrypt_key = COOKIE_ENCRYPT_KEY;
        String cookieValue = ctr.getCookie(key);
        if (cookieValue == null) {
            return null;
        }
        String value = new String(Base64Kit.decode((String)cookieValue));
        return CookieUtil.getFromCookieInfo(encrypt_key, value);
    }

    public static String buildCookieValue(String value, int maxAgeInSeconds) {
        String encrypt_key = COOKIE_ENCRYPT_KEY;
        long saveTime = System.currentTimeMillis();
        String encrypt_value = CookieUtil.encrypt(encrypt_key, saveTime, maxAgeInSeconds + "", value);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(encrypt_value);
        stringBuilder.append(COOKIE_SEPARATOR);
        stringBuilder.append(saveTime);
        stringBuilder.append(COOKIE_SEPARATOR);
        stringBuilder.append(maxAgeInSeconds);
        stringBuilder.append(COOKIE_SEPARATOR);
        stringBuilder.append(Base64Kit.encode((String)value));
        return Base64Kit.encode((String)stringBuilder.toString());
    }

    private static String encrypt(String encrypt_key, long saveTime, String maxAgeInSeconds, String value) {
        if ("JBOOT_DEFAULT_ENCRYPT_KEY".equals(encrypt_key)) {
            log.warn("warn!!! encrypt key is defalut value. please config \"jboot.web.cookieEncryptKey = xxx\" in jboot.properties ");
        }
        return HashKit.md5((String)(encrypt_key + saveTime + maxAgeInSeconds + value));
    }

    public static String getFromCookieInfo(String encrypt_key, String cookieValue) {
        long maxtime;
        if (StrUtil.isBlank((String)cookieValue)) {
            return null;
        }
        String[] cookieStrings = cookieValue.split(COOKIE_SEPARATOR);
        if (cookieStrings == null || cookieStrings.length != 4) {
            return null;
        }
        String encrypt_value = cookieStrings[0];
        String saveTime = cookieStrings[1];
        String maxAgeInSeconds = cookieStrings[2];
        String value = Base64Kit.decodeToStr((String)cookieStrings[3]);
        String encrypt = CookieUtil.encrypt(encrypt_key, Long.valueOf(saveTime), maxAgeInSeconds, value);
        if (!encrypt.equals(encrypt_value)) {
            return null;
        }
        long stime = Long.parseLong(saveTime);
        if (stime + (maxtime = Long.parseLong(maxAgeInSeconds) * 1000L) - System.currentTimeMillis() > 0L) {
            return value;
        }
        return null;
    }

    public static Long getLong(Controller ctr, String key) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? null : Long.valueOf(Long.parseLong(value));
    }

    public static long getLong(Controller ctr, String key, long defalut) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? defalut : Long.parseLong(value);
    }

    public static Integer getInt(Controller ctr, String key) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static int getInt(Controller ctr, String key, int defalut) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? defalut : Integer.parseInt(value);
    }

    public static BigInteger getBigInteger(Controller ctr, String key) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? null : new BigInteger(value);
    }

    public static BigInteger getBigInteger(Controller ctr, String key, BigInteger defalut) {
        String value = CookieUtil.get(ctr, key);
        return null == value ? defalut : new BigInteger(value);
    }
}

