/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.processer;

import io.jboot.support.shiro.processer.AuthorizeResult;
import io.jboot.support.shiro.processer.IShiroAuthorizeProcesser;
import java.util.Arrays;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;

public class ShiroRequiresRolesProcesser
implements IShiroAuthorizeProcesser {
    private final RequiresRoles requiresRoles;

    public ShiroRequiresRolesProcesser(RequiresRoles requiresRoles) {
        this.requiresRoles = requiresRoles;
    }

    @Override
    public AuthorizeResult authorize() {
        String[] roles = this.requiresRoles.value();
        try {
            if (roles.length == 1) {
                SecurityUtils.getSubject().checkRole(roles[0]);
                return AuthorizeResult.ok();
            }
            if (Logical.AND.equals((Object)this.requiresRoles.logical())) {
                SecurityUtils.getSubject().checkRoles(Arrays.asList(roles));
                return AuthorizeResult.ok();
            }
            if (Logical.OR.equals((Object)this.requiresRoles.logical())) {
                boolean hasAtLeastOneRole = false;
                for (String role : roles) {
                    if (!SecurityUtils.getSubject().hasRole(role)) continue;
                    hasAtLeastOneRole = true;
                }
                if (!hasAtLeastOneRole) {
                    SecurityUtils.getSubject().checkRole(roles[0]);
                }
            }
            return AuthorizeResult.ok();
        }
        catch (AuthorizationException e) {
            return AuthorizeResult.fail(2);
        }
    }
}

