/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.directives;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.support.shiro.directives.JbootShiroDirectiveBase;
import io.jboot.utils.ArrayUtil;
import io.jboot.web.directive.annotation.JFinalDirective;
import java.util.ArrayList;

@JFinalDirective(value="shiroHasAllRoles")
public class ShiroHasAllRolesDirective
extends JbootShiroDirectiveBase {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.getExprArray().length == 0) {
            throw new IllegalArgumentException("#shiroHasAllRoles argument must not be empty");
        }
        super.setExprList(exprList);
    }

    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        if (this.getSubject() != null && ArrayUtil.isNotEmpty(this.exprList.getExprArray())) {
            ArrayList<String> roles = new ArrayList<String>();
            for (Expr expr : this.exprList.getExprArray()) {
                roles.add(expr.eval(scope).toString());
            }
            if (this.getSubject().hasAllRoles(roles)) {
                this.renderBody(env, scope, writer);
            }
        }
    }

    public boolean hasEnd() {
        return true;
    }
}

