/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.directives;

import com.jfinal.template.Env;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.Scope;
import io.jboot.support.shiro.directives.JbootShiroDirectiveBase;
import io.jboot.utils.ArrayUtil;
import io.jboot.web.directive.annotation.JFinalDirective;

@JFinalDirective(value="shiroHasAllPermission")
public class ShiroHasAllPermissionDirective
extends JbootShiroDirectiveBase {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.getExprArray().length == 0) {
            throw new IllegalArgumentException("#shiroHasAllPermission argument must not be empty");
        }
        super.setExprList(exprList);
    }

    @Override
    public void onRender(Env env, Scope scope, Writer writer) {
        if (this.getSubject() != null && ArrayUtil.isNotEmpty(this.exprList.getExprArray())) {
            boolean hasAllPermission = true;
            for (Expr expr : this.exprList.getExprArray()) {
                if (this.getSubject().isPermitted(expr.eval(scope).toString())) continue;
                hasAllPermission = false;
                break;
            }
            if (hasAllPermission) {
                this.renderBody(env, scope, writer);
            }
        }
    }

    public boolean hasEnd() {
        return true;
    }
}

