/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro.cache;

import io.jboot.Jboot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;

public class JbootShiroCache<K, V>
implements Cache<K, V> {
    private String cacheName;

    public JbootShiroCache(String cacheName) {
        this.cacheName = "shiroCache:" + cacheName;
    }

    public V get(K key) throws CacheException {
        return (V)Jboot.getCache().get(this.cacheName, key);
    }

    public V put(K key, V value) throws CacheException {
        Jboot.getCache().put(this.cacheName, key, value);
        return value;
    }

    public V remove(K key) throws CacheException {
        Object value = Jboot.getCache().get(this.cacheName, key);
        Jboot.getCache().remove(this.cacheName, key);
        return (V)value;
    }

    public void clear() throws CacheException {
        Jboot.getCache().removeAll(this.cacheName);
    }

    public int size() {
        Set<K> keys = this.keys();
        return keys == null ? 0 : keys.size();
    }

    public Set<K> keys() {
        List list = Jboot.getCache().getKeys(this.cacheName);
        return list == null ? null : new HashSet(list);
    }

    public Collection<V> values() {
        List values = Collections.emptyList();
        List keys = Jboot.getCache().getKeys(this.cacheName);
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            values = new ArrayList(keys.size());
            for (Object key : keys) {
                Object value = Jboot.getCache().get(this.cacheName, key);
                if (value == null) continue;
                values.add(value);
            }
        }
        return values;
    }
}

