/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro;

import io.jboot.support.shiro.processer.AuthorizeResult;
import io.jboot.support.shiro.processer.IShiroAuthorizeProcesser;
import java.util.ArrayList;
import java.util.List;

public class ShiroAuthorizeProcesserInvoker {
    List<IShiroAuthorizeProcesser> processers;

    public void addProcesser(IShiroAuthorizeProcesser processer) {
        if (this.processers == null) {
            this.processers = new ArrayList<IShiroAuthorizeProcesser>();
        }
        if (!this.processers.contains(processer)) {
            this.processers.add(processer);
        }
    }

    public List<IShiroAuthorizeProcesser> getProcessers() {
        return this.processers;
    }

    public AuthorizeResult invoke() {
        if (this.processers == null || this.processers.size() == 0) {
            return AuthorizeResult.ok();
        }
        for (IShiroAuthorizeProcesser processer : this.processers) {
            AuthorizeResult result = processer.authorize();
            if (result.isOk()) continue;
            return result;
        }
        return AuthorizeResult.ok();
    }
}

