/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.shiro;

import com.jfinal.config.Routes;
import io.jboot.Jboot;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.shiro.JbootShiroConfig;
import io.jboot.support.shiro.JbootShiroInvokeListener;
import io.jboot.support.shiro.ShiroAuthorizeProcesserInvoker;
import io.jboot.support.shiro.processer.AuthorizeResult;
import io.jboot.support.shiro.processer.IShiroAuthorizeProcesser;
import io.jboot.support.shiro.processer.ShiroClear;
import io.jboot.support.shiro.processer.ShiroRequiresAuthenticationProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresGuestProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresPermissionsProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresRolesProcesser;
import io.jboot.support.shiro.processer.ShiroRequiresUserProcesser;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.utils.ControllerUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;

public class JbootShiroManager {
    private static JbootShiroManager me = new JbootShiroManager();
    private JbootShiroConfig jbootShiroConfig = Jboot.config(JbootShiroConfig.class);
    private ConcurrentHashMap<String, ShiroAuthorizeProcesserInvoker> invokers = new ConcurrentHashMap();
    private ShiroRequiresAuthenticationProcesser requiresAuthenticationProcesser = new ShiroRequiresAuthenticationProcesser();
    private ShiroRequiresUserProcesser requiresUserProcesser = new ShiroRequiresUserProcesser();
    private ShiroRequiresGuestProcesser requiresGuestProcesser = new ShiroRequiresGuestProcesser();
    private JbootShiroInvokeListener invokeListener;

    private JbootShiroManager() {
    }

    public static JbootShiroManager me() {
        return me;
    }

    public void init(List<Routes.Route> routes) {
        if (!this.jbootShiroConfig.isConfigOK()) {
            return;
        }
        this.initInvokers(routes);
    }

    private void initInvokers(List<Routes.Route> routes) {
        Set<String> excludedMethodName = ControllerUtil.buildExcludedMethodName();
        for (Routes.Route route : routes) {
            Method[] methods;
            Class controllerClass = route.getControllerClass();
            String controllerKey = route.getControllerKey();
            Annotation[] controllerAnnotations = controllerClass.getAnnotations();
            for (Method method : methods = controllerClass.getMethods()) {
                if (excludedMethodName.contains(method.getName()) || method.getAnnotation(ShiroClear.class) != null) continue;
                Annotation[] methodAnnotations = method.getAnnotations();
                Annotation[] allAnnotations = ArrayUtil.concat(controllerAnnotations, new Annotation[][]{methodAnnotations});
                String actionKey = ControllerUtil.createActionKey(controllerClass, method, controllerKey);
                ShiroAuthorizeProcesserInvoker invoker = new ShiroAuthorizeProcesserInvoker();
                for (Annotation annotation : allAnnotations) {
                    IShiroAuthorizeProcesser processer;
                    if (annotation.annotationType() == RequiresPermissions.class) {
                        processer = new ShiroRequiresPermissionsProcesser((RequiresPermissions)annotation);
                        invoker.addProcesser(processer);
                        continue;
                    }
                    if (annotation.annotationType() == RequiresRoles.class) {
                        processer = new ShiroRequiresRolesProcesser((RequiresRoles)annotation);
                        invoker.addProcesser(processer);
                        continue;
                    }
                    if (annotation.annotationType() == RequiresUser.class) {
                        invoker.addProcesser(this.requiresUserProcesser);
                        continue;
                    }
                    if (annotation.annotationType() == RequiresAuthentication.class) {
                        invoker.addProcesser(this.requiresAuthenticationProcesser);
                        continue;
                    }
                    if (annotation.annotationType() != RequiresGuest.class) continue;
                    invoker.addProcesser(this.requiresGuestProcesser);
                }
                if (invoker.getProcessers() == null || invoker.getProcessers().size() <= 0) continue;
                this.invokers.put(actionKey, invoker);
            }
        }
    }

    public AuthorizeResult invoke(String actionKey) {
        ShiroAuthorizeProcesserInvoker invoker = this.invokers.get(actionKey);
        if (invoker == null) {
            return AuthorizeResult.ok();
        }
        return invoker.invoke();
    }

    public JbootShiroInvokeListener getInvokeListener() {
        if (this.invokeListener != null) {
            return this.invokeListener;
        }
        this.invokeListener = JbootShiroInvokeListener.DEFAULT;
        if (StrUtil.isNotBlank(this.jbootShiroConfig.getInvokeListener())) {
            this.invokeListener = (JbootShiroInvokeListener)ClassUtil.newInstance(this.jbootShiroConfig.getInvokeListener());
            if (this.invokeListener == null) {
                throw new JbootIllegalConfigException("can not find Class : " + this.jbootShiroConfig.getInvokeListener() + " please config jboot.shiro.invokeListener correct. ");
            }
        }
        return this.invokeListener;
    }
}

