/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.support.seata.annotation.SeataGlobalLock;
import io.jboot.support.seata.annotation.SeataGlobalTransactional;
import io.jboot.support.seata.interceptor.SeataGlobalTransactionHandler;
import io.jboot.web.fixedinterceptor.FixedInterceptor;
import java.lang.reflect.Method;

public class SeataGlobalTransactionalInterceptor
implements Interceptor,
FixedInterceptor {
    @Override
    public void intercept(Invocation inv) {
        if (!JbootSeataManager.me().isEnable()) {
            inv.invoke();
            return;
        }
        Method method = inv.getMethod();
        SeataGlobalTransactional globalTrxAnno = method.getAnnotation(SeataGlobalTransactional.class);
        SeataGlobalLock globalLockAnno = method.getAnnotation(SeataGlobalLock.class);
        try {
            if (globalTrxAnno != null) {
                this.handleGlobalTransaction(inv, globalTrxAnno);
            } else if (globalLockAnno != null) {
                this.handleGlobalLock(inv);
            } else {
                inv.invoke();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void handleGlobalLock(Invocation inv) throws Exception {
        JbootSeataManager.me().getGlobalLockTemplate().execute(() -> {
            try {
                inv.invoke();
                return inv.getReturnValue();
            }
            catch (Throwable e) {
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new RuntimeException(e);
            }
        });
    }

    private Object handleGlobalTransaction(Invocation invocation, SeataGlobalTransactional globalTrxAnno) throws Throwable {
        return SeataGlobalTransactionHandler.handleGlobalTransaction(invocation, globalTrxAnno);
    }
}

