/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata.interceptor;

import com.jfinal.aop.Invocation;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.support.seata.annotation.SeataGlobalTransactional;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.tm.api.FailureHandler;
import io.seata.tm.api.TransactionalExecutor;
import io.seata.tm.api.transaction.NoRollbackRule;
import io.seata.tm.api.transaction.RollbackRule;
import io.seata.tm.api.transaction.TransactionInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class SeataGlobalTransactionHandler {
    public static Object handleGlobalTransaction(final Invocation invocation, final SeataGlobalTransactional globalTrxAnno) throws Throwable {
        try {
            return JbootSeataManager.me().getTransactionalTemplate().execute(new TransactionalExecutor(){

                public Object execute() throws Throwable {
                    invocation.invoke();
                    return invocation.getReturnValue();
                }

                public String name() {
                    String name = globalTrxAnno.name();
                    if (!StringUtils.isNullOrEmpty((String)name)) {
                        return name;
                    }
                    return SeataGlobalTransactionHandler.formatMethod(invocation.getMethod());
                }

                public TransactionInfo getTransactionInfo() {
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(globalTrxAnno.timeoutMills());
                    transactionInfo.setName(this.name());
                    LinkedHashSet<Object> rollbackRules = new LinkedHashSet<Object>();
                    for (Class<? extends Throwable> clazz : globalTrxAnno.rollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : globalTrxAnno.rollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class<? extends Throwable> clazz : globalTrxAnno.noRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule((Class)clazz));
                    }
                    for (String string : globalTrxAnno.noRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
        }
        catch (TransactionalExecutor.ExecutionException e) {
            FailureHandler failureHandler = JbootSeataManager.me().getFailureHandler();
            TransactionalExecutor.Code code = e.getCode();
            switch (code) {
                case RollbackDone: {
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    failureHandler.onBeginFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case CommitFailure: {
                    failureHandler.onCommitFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
                case RollbackFailure: {
                    failureHandler.onRollbackFailure(e.getTransaction(), e.getCause());
                    throw e.getCause();
                }
            }
            throw new ShouldNeverHappenException("Unknown TransactionalExecutor.Code: " + code);
        }
    }

    private static String formatMethod(Method method) {
        String paramTypes = Arrays.stream(method.getParameterTypes()).map(Class::getName).reduce((p1, p2) -> String.format("%s, %s", p1, p2)).orElse("");
        return method.getName() + "(" + paramTypes + ")";
    }
}

