/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.seata.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.jfinal.log.Log;
import io.jboot.support.seata.JbootSeataManager;
import io.seata.core.context.RootContext;

@Activate(group={"provider", "consumer"}, order=100)
public class TransactionPropagationFilter
implements Filter {
    private static final Log LOGGER = Log.getLog(TransactionPropagationFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!JbootSeataManager.me().isEnable()) {
            return invoker.invoke(invocation);
        }
        String xid = RootContext.getXID();
        String rpcXid = RpcContext.getContext().getAttachment("TX_XID");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext[" + xid + "] xid in RpcContext[" + rpcXid + "]");
        }
        boolean bind = false;
        if (xid != null) {
            RpcContext.getContext().setAttachment("TX_XID", xid);
        } else if (rpcXid != null) {
            RootContext.bind((String)rpcXid);
            bind = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind[" + rpcXid + "] to RootContext");
            }
        }
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            if (bind) {
                String unbindXid = RootContext.unbind();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unbind[" + unbindXid + "] from RootContext");
                }
                if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                    LOGGER.warn("xid in change during RPC from " + rpcXid + " to " + unbindXid);
                    if (unbindXid != null) {
                        RootContext.bind((String)unbindXid);
                        LOGGER.warn("bind [" + unbindXid + "] back to RootContext");
                    }
                }
            }
        }
    }
}

