/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.redis.jedis;

import com.jfinal.log.Log;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedisBase;
import io.jboot.support.redis.JbootRedisConfig;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class JbootJedisImpl
extends JbootRedisBase {
    protected JedisPool jedisPool;
    protected JbootRedisConfig config;
    private static final Log LOG = Log.getLog(JbootJedisImpl.class);

    public JbootJedisImpl(JbootRedisConfig config) {
        super(config);
        this.config = config;
        String host = config.getHost();
        Integer port = config.getPort();
        Integer timeout = config.getTimeout();
        String password = config.getPassword();
        Integer database = config.getDatabase();
        String clientName = config.getClientName();
        if (host.contains(":")) {
            port = Integer.valueOf(host.split(":")[1]);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        if (StrUtil.isNotBlank(config.getTestWhileIdle())) {
            poolConfig.setTestWhileIdle(config.getTestWhileIdle().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getTestOnBorrow())) {
            poolConfig.setTestOnBorrow(config.getTestOnBorrow().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getTestOnCreate())) {
            poolConfig.setTestOnCreate(config.getTestOnCreate().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getTestOnReturn())) {
            poolConfig.setTestOnReturn(config.getTestOnReturn().booleanValue());
        }
        if (StrUtil.isNotBlank(config.getMinEvictableIdleTimeMillis())) {
            poolConfig.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeMillis().longValue());
        }
        if (StrUtil.isNotBlank(config.getTimeBetweenEvictionRunsMillis())) {
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsMillis().longValue());
        }
        if (StrUtil.isNotBlank(config.getNumTestsPerEvictionRun())) {
            poolConfig.setNumTestsPerEvictionRun(config.getNumTestsPerEvictionRun().intValue());
        }
        if (StrUtil.isNotBlank(config.getMaxTotal())) {
            poolConfig.setMaxTotal(config.getMaxTotal().intValue());
        }
        if (StrUtil.isNotBlank(config.getMaxIdle())) {
            poolConfig.setMaxIdle(config.getMaxIdle().intValue());
        }
        if (StrUtil.isNotBlank(config.getMinIdle())) {
            poolConfig.setMinIdle(config.getMinIdle().intValue());
        }
        if (StrUtil.isNotBlank(config.getMaxWaitMillis())) {
            poolConfig.setMaxWaitMillis((long)config.getMaxWaitMillis().intValue());
        }
        this.jedisPool = JbootJedisImpl.newJedisPool(poolConfig, host, port, timeout, password, database, clientName);
    }

    public static JedisPool newJedisPool(JedisPoolConfig jedisPoolConfig, String host, Integer port, Integer timeout, String password, Integer database, String clientName) {
        JedisPool jedisPool = port != null && timeout != null && password != null && database != null && clientName != null ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port.intValue(), timeout.intValue(), password, database.intValue(), clientName) : (port != null && timeout != null && password != null && database != null ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port.intValue(), timeout.intValue(), password, database.intValue()) : (port != null && timeout != null && password != null ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port.intValue(), timeout.intValue(), password) : (port != null && timeout != null ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port.intValue(), timeout.intValue()) : (port != null ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port.intValue()) : new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host)))));
        return jedisPool;
    }

    public JbootJedisImpl(JedisPool jedisPool) {
        super(null);
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.set(this.keyToBytes(key), this.valueToBytes(value));
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.setnx(this.keyToBytes(key), this.valueToBytes(value));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setWithoutSerialize(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.set(this.keyToBytes(key), value.toString().getBytes());
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setex(Object key, int seconds, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.setex(this.keyToBytes(key), seconds, this.valueToBytes(value));
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.get(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWithoutSerialize(Object key) {
        Jedis jedis = this.getJedis();
        try {
            byte[] bytes = jedis.get(this.keyToBytes(key));
            if (bytes == null || bytes.length == 0) {
                String string = null;
                return string;
            }
            String string = new String(bytes);
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(this.keysToBytesArray(keys));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keys(String pattern) {
        Jedis jedis = this.getJedis();
        try {
            Set set = jedis.keys(pattern);
            return set;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mset(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        Jedis jedis = this.getJedis();
        try {
            byte[][] kv = new byte[keysValues.length][];
            for (int i = 0; i < keysValues.length; ++i) {
                kv[i] = i % 2 == 0 ? this.keyToBytes(keysValues[i]) : this.valueToBytes(keysValues[i]);
            }
            String string = jedis.mset((byte[][])kv);
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List mget(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            byte[][] keysBytesArray = this.keysToBytesArray(keys);
            List data = jedis.mget(keysBytesArray);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.decr(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrBy(Object key, long longValue) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.decrBy(this.keyToBytes(key), longValue);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.incr(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(Object key, long longValue) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.incrBy(this.keyToBytes(key), longValue);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Object key) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.exists(this.keyToBytes(key));
            return bl;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    @Override
    public String randomKey() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.randomKey();
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rename(Object oldkey, Object newkey) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.rename(this.keyToBytes(oldkey), this.keyToBytes(newkey));
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long move(Object key, int dbIndex) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.move(this.keyToBytes(key), dbIndex);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String migrate(String host, int port, Object key, int destinationDb, int timeout) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.migrate(host, port, this.keyToBytes(key), destinationDb, timeout);
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String select(int databaseIndex) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.select(databaseIndex);
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expire(Object key, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expire(this.keyToBytes(key), seconds);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expireAt(Object key, long unixTime) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expireAt(this.keyToBytes(key), unixTime);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpire(Object key, long milliseconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pexpire(this.keyToBytes(key), milliseconds);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpireAt(Object key, long millisecondsTimestamp) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pexpireAt(this.keyToBytes(key), millisecondsTimestamp);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getSet(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.getSet(this.keyToBytes(key), this.valueToBytes(value)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long persist(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.persist(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String type(Object key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.type(this.keyToBytes(key));
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long ttl(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.ttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pttl(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long objectRefcount(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.objectRefcount(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long objectIdletime(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.objectIdletime(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(Object key, Object field, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hset(this.keyToBytes(key), this.valueToBytes(field), this.valueToBytes(value));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(Object key, Map<Object, Object> hash) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], byte[]> para = new HashMap<byte[], byte[]>();
            for (Map.Entry<Object, Object> e : hash.entrySet()) {
                para.put(this.valueToBytes(e.getKey()), this.valueToBytes(e.getValue()));
            }
            String string = jedis.hmset(this.keyToBytes(key), para);
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T hget(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.hget(this.keyToBytes(key), this.valueToBytes(field)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List hmget(Object key, Object ... fields) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.hmget(this.keyToBytes(key), this.valuesToBytesArray(fields));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(Object key, Object ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hdel(this.keyToBytes(key), this.valuesToBytesArray(fields));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hexists(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.hexists(this.keyToBytes(key), this.valueToBytes(field));
            return bl;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map hgetAll(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Map data = jedis.hgetAll(this.keyToBytes(key));
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry e : data.entrySet()) {
                result.put(this.valueFromBytes((byte[])e.getKey()), this.valueFromBytes((byte[])e.getValue()));
            }
            HashMap<Object, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List hvals(Object key) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.hvals(this.keyToBytes(key));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> hkeys(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Set fieldSet = jedis.hkeys(this.keyToBytes(key));
            HashSet<Object> result = new HashSet<Object>();
            this.fieldSetFromBytesSet(fieldSet, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hlen(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(Object key, Object field, long value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hincrBy(this.keyToBytes(key), this.valueToBytes(field), value);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double hincrByFloat(Object key, Object field, double value) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.hincrByFloat(this.keyToBytes(key), this.valueToBytes(field), value);
            return d;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lindex(Object key, long index) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.lindex(this.keyToBytes(key), index));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.llen(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lpop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.lpop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lpush(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lset(Object key, long index, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.lset(this.keyToBytes(key), index, this.valueToBytes(value));
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(Object key, long count, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lrem(this.keyToBytes(key), count, this.valueToBytes(value));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List lrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.lrange(this.keyToBytes(key), start, end);
            if (data != null) {
                List list = this.valueListFromBytesList(data);
                return list;
            }
            ArrayList arrayList = new ArrayList(0);
            return arrayList;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ltrim(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.ltrim(this.keyToBytes(key), start, end);
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T rpop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.rpop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T rpoplpush(Object srcKey, Object dstKey) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.rpoplpush(this.keyToBytes(srcKey), this.keyToBytes(dstKey)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.rpush(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List blpop(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.blpop(this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List blpop(Integer timeout, Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.blpop(timeout.intValue(), this.keysToBytesArray(keys));
            if (data != null && data.size() == 2) {
                ArrayList<Object> objects = new ArrayList<Object>();
                objects.add(new String((byte[])data.get(0)));
                objects.add(this.valueFromBytes((byte[])data.get(1)));
                ArrayList<Object> arrayList = objects;
                return arrayList;
            }
            List list = null;
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List brpop(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.brpop(this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List brpop(Integer timeout, Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.brpop(timeout.intValue(), this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    @Override
    public String ping() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.ping();
            return string;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.sadd(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long scard(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.scard(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T spop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.spop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set smembers(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.smembers(this.keyToBytes(key));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sismember(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.sismember(this.keyToBytes(key), this.valueToBytes(member));
            return bl;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set sinter(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sinter(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T srandmember(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.srandmember(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List srandmember(Object key, int count) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.srandmember(this.keyToBytes(key), count);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.srem(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set sunion(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sunion(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set sdiff(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sdiff(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(Object key, double score, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zadd(this.keyToBytes(key), score, this.valueToBytes(member));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(Object key, Map<Object, Double> scoreMembers) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], Double> para = new HashMap<byte[], Double>();
            for (Map.Entry<Object, Double> e : scoreMembers.entrySet()) {
                para.put(this.valueToBytes(e.getKey()), e.getValue());
            }
            Long l = jedis.zadd(this.keyToBytes(key), para);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcard(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zcard(this.keyToBytes(key));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(Object key, double min, double max) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zcount(this.keyToBytes(key), min, max);
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(Object key, double score, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.zincrby(this.keyToBytes(key), score, this.valueToBytes(member));
            return d;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set zrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrange(this.keyToBytes(key), start, end);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set zrevrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrevrange(this.keyToBytes(key), start, end);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set zrangeByScore(Object key, double min, double max) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrangeByScore(this.keyToBytes(key), min, max);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrank(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrank(this.keyToBytes(key), this.valueToBytes(member));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrevrank(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrevrank(this.keyToBytes(key), this.valueToBytes(member));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrem(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zscore(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.zscore(this.keyToBytes(key), this.valueToBytes(member));
            return d;
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String channel, String message) {
        Jedis jedis = this.getJedis();
        try {
            jedis.publish(channel, message);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(byte[] channel, byte[] message) {
        Jedis jedis = this.getJedis();
        try {
            jedis.publish(channel, message);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    @Override
    public void subscribe(final JedisPubSub listener, final String ... channels) {
        new Thread("jboot-redis-subscribe-JedisPubSub"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Jedis jedis = JbootJedisImpl.this.getJedis();
                    try {
                        jedis.subscribe(listener, channels);
                        LOG.warn("Disconnect to redis channels : " + Arrays.toString(channels));
                    }
                    catch (JedisConnectionException e) {
                        LOG.error("Failed connect to redis, reconnect it.", (Throwable)e);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                    finally {
                        JbootJedisImpl.this.returnResource(jedis);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void subscribe(final BinaryJedisPubSub binaryListener, final byte[] ... channels) {
        new Thread("jboot-redis-subscribe-BinaryJedisPubSub"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Jedis jedis = JbootJedisImpl.this.getJedis();
                    try {
                        jedis.subscribe(binaryListener, channels);
                        LOG.warn("Disconnect to redis channel in subscribe binaryListener!");
                    }
                    catch (JedisConnectionException e) {
                        LOG.error("Failed connect to redis, reconnect it.", (Throwable)e);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                    finally {
                        JbootJedisImpl.this.returnResource(jedis);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public Jedis getJedis() {
        try {
            return this.jedisPool.getResource();
        }
        catch (JedisConnectionException e) {
            throw new JbootIllegalConfigException("can not connect to redis host  " + this.config.getHost() + ":" + this.config.getPort() + " , cause : " + e.toString(), e);
        }
    }

    public void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }
}

