/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.metric;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.support.metric.JbootMetricConfig;
import io.jboot.support.metric.annotation.EnableMetricConcurrency;
import io.jboot.support.metric.annotation.EnableMetricCounter;
import io.jboot.support.metric.annotation.EnableMetricHistogram;
import io.jboot.support.metric.annotation.EnableMetricMeter;
import io.jboot.support.metric.annotation.EnableMetricTimer;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.fixedinterceptor.FixedInterceptor;

public class JbootMetricInterceptor
implements Interceptor,
FixedInterceptor {
    private static JbootMetricConfig config = Jboot.config(JbootMetricConfig.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(Invocation inv) {
        EnableMetricTimer timerAnnotation;
        EnableMetricHistogram histogramAnnotation;
        EnableMetricMeter meterAnnotation;
        if (!config.isConfigOk()) {
            inv.invoke();
            return;
        }
        Timer.Context timerContext = null;
        EnableMetricCounter counterAnnotation = inv.getMethod().getAnnotation(EnableMetricCounter.class);
        if (counterAnnotation != null) {
            String value = AnnotationUtil.get(counterAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".counter" : value;
            Counter counter = Jboot.getMetric().counter(name);
            counter.inc();
        }
        Counter concurrencyRecord = null;
        EnableMetricConcurrency concurrencyAnnotation = inv.getMethod().getAnnotation(EnableMetricConcurrency.class);
        if (concurrencyAnnotation != null) {
            String value = AnnotationUtil.get(concurrencyAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".concurrency" : value;
            concurrencyRecord = Jboot.getMetric().counter(name);
            concurrencyRecord.inc();
        }
        if ((meterAnnotation = inv.getMethod().getAnnotation(EnableMetricMeter.class)) != null) {
            String value = AnnotationUtil.get(meterAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".meter" : value;
            Meter meter = Jboot.getMetric().meter(name);
            meter.mark();
        }
        if ((histogramAnnotation = inv.getMethod().getAnnotation(EnableMetricHistogram.class)) != null) {
            String value = AnnotationUtil.get(histogramAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".histogram" : value;
            Histogram histogram = Jboot.getMetric().histogram(name);
            histogram.update(histogramAnnotation.update());
        }
        if ((timerAnnotation = inv.getMethod().getAnnotation(EnableMetricTimer.class)) != null) {
            String value = AnnotationUtil.get(timerAnnotation.value());
            String name = StrUtil.isBlank((String)value) ? inv.getController().getClass().getName() + "." + inv.getMethodName() + ".timer" : value;
            Timer timer = Jboot.getMetric().timer(name);
            timerContext = timer.time();
        }
        try {
            inv.invoke();
        }
        finally {
            if (concurrencyRecord != null) {
                concurrencyRecord.dec();
            }
            if (timerContext != null) {
                timerContext.stop();
            }
        }
    }
}

