/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.support.jwt;

import com.jfinal.aop.Invocation;
import io.jboot.support.jwt.JwtManager;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import io.jboot.web.fixedinterceptor.FixedInterceptor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JwtInterceptor
implements FixedInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(Invocation inv) {
        if (!JwtManager.me().getConfig().isConfigOk()) {
            inv.invoke();
            return;
        }
        HttpServletRequest request = inv.getController().getRequest();
        String token = request.getHeader(JwtManager.me().getHttpHeaderName());
        if (StrUtil.isBlank((String)token)) {
            this.processInvoke(inv, null);
            return;
        }
        Map map = JwtManager.me().parseJwtToken(token);
        if (map == null) {
            this.processInvoke(inv, null);
            return;
        }
        try {
            JwtManager.me().holdJwts(map);
            this.processInvoke(inv, map);
        }
        finally {
            JwtManager.me().releaseJwts();
        }
    }

    private void processInvoke(Invocation inv, Map oldData) {
        inv.invoke();
        if (!(inv.getController() instanceof JbootController)) {
            return;
        }
        JbootController jbootController = (JbootController)inv.getController();
        HashMap<String, Object> jwtMap = jbootController.getJwtAttrs();
        if (jwtMap == null || jwtMap.isEmpty()) {
            this.refreshIfNecessary(inv, oldData);
            return;
        }
        String token = JwtManager.me().createJwtToken(jwtMap);
        HttpServletResponse response = inv.getController().getResponse();
        response.addHeader(JwtManager.me().getHttpHeaderName(), token);
    }

    private void refreshIfNecessary(Invocation inv, Map oldData) {
        if (oldData == null) {
            return;
        }
        Long isuuedAtMillis = (Long)oldData.get("isuuedAt");
        if (isuuedAtMillis == null || JwtManager.me().getConfig().getValidityPeriod() <= 0L) {
            return;
        }
        Long nowMillis = System.currentTimeMillis();
        long savedMillis = nowMillis - isuuedAtMillis;
        if (savedMillis > JwtManager.me().getConfig().getValidityPeriod() / 2L) {
            String token = JwtManager.me().createJwtToken(oldData);
            HttpServletResponse response = inv.getController().getResponse();
            response.addHeader(JwtManager.me().getHttpHeaderName(), token);
        }
    }
}

