/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.dialect;

import com.jfinal.plugin.activerecord.dialect.OracleDialect;
import io.jboot.db.dialect.DialectKit;
import io.jboot.db.dialect.IJbootModelDialect;
import io.jboot.db.model.Column;
import io.jboot.exception.JbootException;
import java.util.List;

public class JbootOracleDialect
extends OracleDialect
implements IJbootModelDialect {
    @Override
    public String forFindByColumns(String table, String loadColumns, List<Column> columns, String orderBy, Object limit) {
        StringBuilder sqlBuilder = DialectKit.forFindByColumns(table, loadColumns, columns, orderBy, ' ');
        if (limit == null) {
            return sqlBuilder.toString();
        }
        if (limit instanceof Number) {
            StringBuilder ret = new StringBuilder();
            ret.append("select * from ( select row_.*, rownum rownum_ from (  ");
            ret.append((CharSequence)sqlBuilder);
            ret.append(" ) row_ where rownum <= ").append(limit).append(") table_alias");
            return ret.toString();
        }
        if (limit instanceof String && limit.toString().contains(",")) {
            String[] startAndEnd = limit.toString().split(",");
            String start = startAndEnd[0];
            String end = startAndEnd[1];
            StringBuilder ret = new StringBuilder();
            ret.append("select * from ( select row_.*, rownum rownum_ from (  ");
            ret.append((CharSequence)sqlBuilder);
            ret.append(" ) row_ where rownum <= ").append(end).append(") table_alias");
            ret.append(" where table_alias.rownum_ > ").append(start);
            return ret.toString();
        }
        throw new JbootException("sql limit is error!,limit must is Number of String like \"0,10\"");
    }

    @Override
    public String forPaginateSelect(String loadColumns) {
        return "SELECT " + loadColumns;
    }

    @Override
    public String forPaginateFrom(String table, List<Column> columns, String orderBy) {
        return DialectKit.forPaginateFrom(table, columns, orderBy, ' ');
    }
}

