/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.dialect;

import io.jboot.db.model.Column;
import io.jboot.db.model.Or;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.StrUtil;
import java.util.List;

public class DialectKit {
    public static void appIfNotEmpty(List<Column> columns, StringBuilder sqlBuilder, char separator) {
        if (ArrayUtil.isNotEmpty(columns)) {
            sqlBuilder.append(" WHERE ");
            int index = 0;
            int last = columns.size() - 1;
            for (Column column : columns) {
                if (column instanceof Or) {
                    DialectKit.appendOrLogic(sqlBuilder);
                } else if (" IN ".equals(column.getLogic())) {
                    DialectKit.appendInLogic(sqlBuilder, index, last, column, separator);
                } else if (" BETWEEN ".equals(column.getLogic())) {
                    DialectKit.appendBetweenLogic(sqlBuilder, index, last, column, separator);
                } else {
                    sqlBuilder.append(separator).append(column.getName()).append(separator).append(column.getLogic());
                    if (column.isMustNeedValue()) {
                        sqlBuilder.append(" ? ");
                    }
                    if (index != last) {
                        sqlBuilder.append(" AND ");
                    }
                }
                ++index;
            }
        }
    }

    public static void appendOrLogic(StringBuilder sqlBuilder) {
        sqlBuilder.delete(sqlBuilder.length() - 5, sqlBuilder.length()).append(" OR ");
    }

    public static void appendInLogic(StringBuilder sqlBuilder, int index, int last, Column column, char separator) {
        sqlBuilder.append(separator).append(column.getName()).append(separator).append(column.getLogic());
        sqlBuilder.append("(");
        Object[] values = (Object[])column.getValue();
        for (int i = 0; i < values.length; ++i) {
            sqlBuilder.append("?,");
        }
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1).append(")");
        if (index != last) {
            sqlBuilder.append(" AND ");
        }
    }

    public static void appendBetweenLogic(StringBuilder sqlBuilder, int index, int last, Column column, char separator) {
        sqlBuilder.append(separator).append(column.getName()).append(separator).append(column.getLogic());
        sqlBuilder.append(" ? ").append(" AND ").append(" ? ");
        if (index != last) {
            sqlBuilder.append(" AND ");
        }
    }

    public static StringBuilder forFindByColumns(String table, String loadColumns, List<Column> columns, String orderBy, char separator) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        sqlBuilder.append(loadColumns).append(" FROM ").append(separator).append(table).append(separator);
        DialectKit.appIfNotEmpty(columns, sqlBuilder, separator);
        if (StrUtil.isNotBlank(orderBy)) {
            sqlBuilder.append(" ORDER BY ").append(orderBy);
        }
        return sqlBuilder;
    }

    public static String forPaginateFrom(String table, List<Column> columns, String orderBy, char separator) {
        StringBuilder sqlBuilder = new StringBuilder(" FROM ").append(separator).append(table).append(separator);
        DialectKit.appIfNotEmpty(columns, sqlBuilder, separator);
        if (StrUtil.isNotBlank(orderBy)) {
            sqlBuilder.append(" ORDER BY ").append(orderBy);
        }
        return sqlBuilder.toString();
    }
}

