/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.jboot.Jboot;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.db.datasource.DataSourceFactory;
import javax.sql.DataSource;

public class HikariDataSourceFactory
implements DataSourceFactory {
    @Override
    public DataSource createDataSource(DataSourceConfig config) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(config.getUrl());
        hikariConfig.setUsername(config.getUser());
        hikariConfig.setPassword(config.getPassword());
        hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)config.isCachePrepStmts());
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)config.getPrepStmtCacheSize());
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)config.getPrepStmtCacheSqlLimit());
        hikariConfig.setDriverClassName(config.getDriverClassName());
        hikariConfig.setPoolName(config.getPoolName());
        hikariConfig.setMaximumPoolSize(config.getMaximumPoolSize());
        if (config.getMaxLifetime() != null) {
            hikariConfig.setMaxLifetime(config.getMaxLifetime().longValue());
        }
        if (config.getIdleTimeout() != null) {
            hikariConfig.setIdleTimeout(config.getIdleTimeout().longValue());
        }
        if (config.getMinimumIdle() != null) {
            hikariConfig.setMinimumIdle(config.getMinimumIdle().intValue());
        }
        if (config.getConnectionInitSql() != null) {
            hikariConfig.setConnectionInitSql(config.getConnectionInitSql());
        }
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        if (Jboot.getMetric() != null) {
            dataSource.setMetricRegistry((Object)Jboot.getMetric());
        }
        return dataSource;
    }
}

