/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import com.google.common.collect.Maps;
import io.jboot.Jboot;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.utils.StrUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class DataSourceConfigManager {
    private static final String DATASOURCE_PREFIX = "jboot.datasource.";
    private static DataSourceConfigManager manager = new DataSourceConfigManager();
    private Map<String, DataSourceConfig> datasourceConfigs = Maps.newHashMap();

    public static DataSourceConfigManager me() {
        return manager;
    }

    private DataSourceConfigManager() {
        DataSourceConfig datasourceConfig = Jboot.config(DataSourceConfig.class, "jboot.datasource");
        if (StrUtil.isBlank((String)datasourceConfig.getName())) {
            datasourceConfig.setName("main");
        }
        this.addConfig(datasourceConfig);
        Properties prop = JbootConfigManager.me().getProperties();
        HashSet<String> datasourceNames = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String[] keySplits;
            String key;
            if (entry.getKey() == null || !(key = entry.getKey().toString().toLowerCase().replace('_', '.')).startsWith(DATASOURCE_PREFIX) || entry.getValue() == null || (keySplits = key.split("\\.")).length != 4) continue;
            datasourceNames.add(keySplits[2]);
        }
        for (String name : datasourceNames) {
            DataSourceConfig dsc = Jboot.config(DataSourceConfig.class, DATASOURCE_PREFIX + name);
            if (StrUtil.isBlank((String)dsc.getName())) {
                dsc.setName(name);
            }
            this.addConfig(dsc);
        }
    }

    public void addConfig(DataSourceConfig config) {
        if (config == null || !config.isConfigOk()) {
            return;
        }
        this.datasourceConfigs.put(config.getName(), config);
    }

    public Map<String, DataSourceConfig> getDatasourceConfigs() {
        return this.datasourceConfigs;
    }

    public DataSourceConfig getMainDatasourceConfig() {
        return this.datasourceConfigs.get("main");
    }
}

