/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.log;

import com.jfinal.log.Log;
import io.jboot.exception.JbootExceptionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class Slf4jLogger
extends Log {
    private Logger logger;

    public Slf4jLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public Slf4jLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public boolean isOk() {
        return this.logger.getClass() != NOPLogger.class;
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void debug(String message, Throwable t) {
        this.logger.debug(message, t);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String message, Throwable t) {
        this.logger.info(message, t);
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void warn(String message, Throwable t) {
        this.logger.warn(message, t);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.logger.error(message, t);
    }

    public void fatal(String message) {
        this.logger.error(message);
    }

    public void fatal(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.logger.error(message, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return true;
    }
}

