/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.log;

import com.jfinal.log.Log;
import io.jboot.exception.JbootExceptionHolder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdkLogger
extends Log {
    private Logger log;
    private String clazzName;

    public JdkLogger(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getName());
        this.clazzName = clazz.getName();
    }

    public JdkLogger(String name) {
        this.log = Logger.getLogger(name);
        this.clazzName = name;
    }

    public void debug(String message) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void debug(String message, Throwable t) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void info(String message) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void info(String message, Throwable t) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void warn(String message) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void warn(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void error(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void error(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public void fatal(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    public void fatal(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }
}

