/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.serializer;

import io.jboot.Jboot;
import io.jboot.components.serializer.FastjsonSerializer;
import io.jboot.components.serializer.FstSerializer;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.components.serializer.JbootSerializerConfig;
import io.jboot.components.serializer.KryoSerializer;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.exception.JbootException;
import io.jboot.utils.ClassUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootSerializerManager {
    private static JbootSerializerManager me;
    private static Map<String, JbootSerializer> serializerCaches;

    public static JbootSerializerManager me() {
        if (me == null) {
            me = ClassUtil.singleton(JbootSerializerManager.class);
        }
        return me;
    }

    public JbootSerializer getSerializer() {
        JbootSerializerConfig config = Jboot.config(JbootSerializerConfig.class);
        return this.getSerializer(config.getType());
    }

    public JbootSerializer getSerializer(String serializerString) {
        JbootSerializer serializer = serializerCaches.get(serializerString);
        if (serializer == null) {
            serializer = this.buildSerializer(serializerString);
            serializerCaches.put(serializerString, serializer);
        }
        return serializer;
    }

    public JbootSerializer buildSerializer(String serializerString) {
        JbootSerializer serializer;
        if (serializerString == null) {
            throw new JbootException("can not get serializer config, please set jboot.serializer value to jboot.proerties");
        }
        if (serializerString != null && serializerString.contains(".") && (serializer = (JbootSerializer)ClassUtil.newInstance(serializerString)) != null) {
            return serializer;
        }
        switch (serializerString) {
            case "kryo": {
                return new KryoSerializer();
            }
            case "fst": {
                return new FstSerializer();
            }
            case "fastjson": {
                return new FastjsonSerializer();
            }
        }
        return JbootSpiLoader.load(JbootSerializer.class, serializerString);
    }

    static {
        serializerCaches = new ConcurrentHashMap<String, JbootSerializer>();
    }
}

