/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.zbus;

import io.jboot.Jboot;
import io.jboot.components.rpc.JbootrpcBase;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.zbus.JbootClientBootstrap;
import io.jboot.components.rpc.zbus.JbootServiceBootstrap;
import io.jboot.components.rpc.zbus.JbootZbusRpcConfig;
import io.jboot.utils.StrUtil;

public class JbootZbusrpc
extends JbootrpcBase {
    JbootServiceBootstrap serviceBootstrap;
    JbootClientBootstrap clientBootstrap;
    JbootZbusRpcConfig zbusConfig = Jboot.config(JbootZbusRpcConfig.class);

    public JbootZbusrpc() {
        if (StrUtil.isBlank((String)this.zbusConfig.getServiceName())) {
            throw new NullPointerException("please config jboot.rpc.zbus.serviceName in your properties.");
        }
        this.serviceBootstrap = new JbootServiceBootstrap();
        this.clientBootstrap = new JbootClientBootstrap();
        this.clientBootstrap.serviceAddress(this.getConfig().getRegistryAddress());
        this.clientBootstrap.serviceName(this.zbusConfig.getServiceName());
        if (StrUtil.isNotBlank(this.zbusConfig.getServiceToken())) {
            this.clientBootstrap.serviceToken(this.zbusConfig.getServiceToken());
        }
    }

    @Override
    public <T> T serviceObtain(Class<T> serviceClass, JbootrpcServiceConfig serviceConfig) {
        String group = StrUtil.isBlank((String)serviceConfig.getGroup()) ? this.getConfig().getDefaultGroup() : serviceConfig.getGroup();
        return this.clientBootstrap.serviceObtain(serviceClass, group, serviceConfig.getVersion());
    }

    @Override
    public <T> boolean serviceExport(Class<T> interfaceClass, Object object, JbootrpcServiceConfig serviceConfig) {
        this.serviceBootstrap.addModule(interfaceClass, object, serviceConfig.getGroup(), serviceConfig.getVersion());
        return true;
    }

    @Override
    public void onInited() {
        try {
            this.serviceBootstrap.serviceAddress(this.getConfig().getRegistryAddress());
            this.serviceBootstrap.serviceName(this.zbusConfig.getServiceName());
            if (StrUtil.isNotBlank(this.zbusConfig.getServiceToken())) {
                this.serviceBootstrap.serviceToken(this.zbusConfig.getServiceToken());
            }
            this.serviceBootstrap.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

