/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.zbus;

import io.jboot.components.rpc.zbus.ZbusUtil;
import io.zbus.mq.Broker;
import io.zbus.rpc.MessageInvoker;
import io.zbus.rpc.RpcConfig;
import io.zbus.rpc.RpcInvoker;
import io.zbus.rpc.bootstrap.mq.ClientBootstrap;
import io.zbus.rpc.transport.mq.RpcMessageInvoker;
import io.zbus.transport.ServerAddress;

public class JbootClientBootstrap
extends ClientBootstrap {
    public <T> T serviceObtain(Class<T> serviceClass, String group, String version) {
        if (this.broker == null) {
            String token = this.producerConfig.getToken();
            if (token != null) {
                for (ServerAddress address : this.brokerConfig.getTrackerList()) {
                    if (address.getToken() != null) continue;
                    address.setToken(token);
                }
            }
            this.broker = new Broker(this.brokerConfig);
        }
        this.producerConfig.setBroker(this.broker);
        RpcMessageInvoker messageInvoker = new RpcMessageInvoker(this.producerConfig, this.topic);
        RpcConfig rpcConfig = new RpcConfig();
        rpcConfig.setModule(ZbusUtil.buildModule(serviceClass, group, version));
        rpcConfig.setMessageInvoker((MessageInvoker)messageInvoker);
        RpcInvoker rpcInvoker = new RpcInvoker(rpcConfig);
        rpcInvoker.getCodec().setRequestTypeInfo(this.requestTypeInfo);
        return (T)RpcInvoker.createProxy(serviceClass, (RpcConfig)rpcConfig);
    }
}

