/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import io.jboot.Jboot;
import io.jboot.components.rpc.JbootrpcBase;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.dubbo.JbootDubborpcConfig;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootDubborpc
extends JbootrpcBase {
    private static final Map<String, Object> singletons = new ConcurrentHashMap<String, Object>();
    private JbootDubborpcConfig dubboConfig = Jboot.config(JbootDubborpcConfig.class);
    private RegistryConfig registryConfig = new RegistryConfig();

    public JbootDubborpc() {
        this.registryConfig.setCheck(Boolean.valueOf(this.getConfig().isRegistryCheck()));
        if (this.getConfig().getRegistryFile() != null) {
            this.registryConfig.setFile(this.getConfig().getRegistryFile());
        }
        if (this.getConfig().isRegistryCallMode()) {
            this.registryConfig.setProtocol(this.getConfig().getRegistryType());
            this.registryConfig.setAddress(this.getConfig().getRegistryAddress());
            this.registryConfig.setUsername(this.getConfig().getRegistryUserName());
            this.registryConfig.setPassword(this.getConfig().getRegistryPassword());
        } else if (this.getConfig().isDirectCallMode()) {
            this.registryConfig.setAddress("N/A");
        }
    }

    private ApplicationConfig createApplicationConfig(String group) {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(group);
        if (this.dubboConfig.getQosEnable() != null && this.dubboConfig.getQosEnable().booleanValue()) {
            applicationConfig.setQosEnable(Boolean.valueOf(true));
            applicationConfig.setQosPort(this.dubboConfig.getQosPort());
            applicationConfig.setQosAcceptForeignIp(this.dubboConfig.getQosAcceptForeignIp());
        } else {
            applicationConfig.setQosEnable(Boolean.valueOf(false));
        }
        return applicationConfig;
    }

    @Override
    public <T> T serviceObtain(Class<T> serviceClass, JbootrpcServiceConfig serviceConfig) {
        String key = String.format("%s:%s:%s", serviceClass.getName(), serviceConfig.getGroup(), serviceConfig.getVersion());
        Object object = singletons.get(key);
        if (object != null) {
            return (T)object;
        }
        ReferenceConfig reference = new ReferenceConfig();
        reference.setApplication(this.createApplicationConfig(serviceConfig.getGroup()));
        reference.setInterface(serviceClass);
        reference.setCheck(Boolean.valueOf(this.getConfig().isConsumerCheck()));
        JbootDubborpc.initReference(reference, serviceConfig);
        if (this.getConfig().isRegistryCallMode()) {
            reference.setRegistry(this.registryConfig);
        } else if (this.getConfig().isDirectCallMode()) {
            if (StrUtil.isBlank((String)this.getConfig().getDirectUrl())) {
                throw new JbootIllegalConfigException("directUrl must not be blank if you use direct call mode\uff0cplease config jboot.rpc.directUrl value");
            }
            reference.setUrl(this.getConfig().getDirectUrl());
        }
        object = reference.get();
        if (object != null) {
            singletons.put(key, object);
        }
        return (T)object;
    }

    @Override
    public <T> boolean serviceExport(Class<T> interfaceClass, Object object, JbootrpcServiceConfig serviceConfig) {
        ProtocolConfig protocolConfig = this.dubboConfig.newProtocolConfig();
        if (protocolConfig.getHost() == null && this.getConfig().getHost() != null) {
            protocolConfig.setHost(this.getConfig().getHost());
        }
        if (protocolConfig.getSerialization() == null && this.getConfig().getSerialization() != null) {
            protocolConfig.setSerialization(this.getConfig().getSerialization());
        }
        protocolConfig.setPort(Integer.valueOf(serviceConfig.getPort()));
        ServiceConfig service = new ServiceConfig();
        service.setApplication(this.createApplicationConfig(serviceConfig.getGroup()));
        service.setRegistry(this.registryConfig);
        service.setProtocol(protocolConfig);
        service.setInterface(interfaceClass);
        service.setRef(object);
        JbootDubborpc.initService(service, serviceConfig);
        service.export();
        return true;
    }

    private static void initReference(ReferenceConfig reference, JbootrpcServiceConfig config) {
        reference.setGroup(config.getGroup());
        reference.setVersion(config.getVersion());
        reference.setTimeout(config.getTimeout());
        if (config.getRetries() != null) {
            reference.setRetries(config.getRetries());
        }
        if (config.getActives() != null) {
            reference.setActives(config.getActives());
        }
        if (config.getLoadbalance() != null) {
            reference.setLoadbalance(config.getLoadbalance());
        }
        if (config.getAsync() != null) {
            reference.setAsync(config.getAsync());
        }
        if (config.getCheck() != null) {
            reference.setCheck(config.getCheck());
        }
        if (StrUtil.isNotBlank(config.getProxy())) {
            reference.setProxy(config.getProxy());
        }
        if (StrUtil.isNotBlank(config.getFilter())) {
            reference.setFilter(config.getFilter());
        }
    }

    private static void initService(ServiceConfig service, JbootrpcServiceConfig config) {
        service.setGroup(config.getGroup());
        service.setVersion(config.getVersion());
        service.setTimeout(config.getTimeout());
        if (config.getRetries() != null) {
            service.setRetries(config.getRetries());
        }
        if (config.getActives() != null) {
            service.setActives(config.getActives());
        }
        if (config.getLoadbalance() != null) {
            service.setLoadbalance(config.getLoadbalance());
        }
        if (config.getAsync() != null) {
            service.setAsync(config.getAsync());
        }
        if (StrUtil.isNotBlank(config.getProxy())) {
            service.setProxy(config.getProxy());
        }
        if (StrUtil.isNotBlank(config.getFilter())) {
            service.setFilter(config.getFilter());
        }
    }
}

